/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.ComponentExternalSchemaDescription;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ComponentExternalSchemaDescription", generator="Immutables")
@Immutable
public final class ImmutableComponentExternalSchemaDescription
implements ComponentExternalSchemaDescription {
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableComponentExternalSchemaDescription(ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions) {
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.initShim = null;
    }

    private StructType getOutputRowStructInitialize() {
        return ComponentExternalSchemaDescription.super.getOutputRowStruct();
    }

    private Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMapInitialize() {
        return ComponentExternalSchemaDescription.super.getSchemaFieldDescriptionsMap();
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    @Override
    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    @Override
    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    public final ImmutableComponentExternalSchemaDescription withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableComponentExternalSchemaDescription((ImmutableList<Component.SchemaFieldDescription>)newValue);
    }

    public final ImmutableComponentExternalSchemaDescription withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableComponentExternalSchemaDescription((ImmutableList<Component.SchemaFieldDescription>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableComponentExternalSchemaDescription && this.equalTo(0, (ImmutableComponentExternalSchemaDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableComponentExternalSchemaDescription another) {
        return this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ComponentExternalSchemaDescription").omitNullValues().add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).toString();
    }

    public static ImmutableComponentExternalSchemaDescription copyOf(ComponentExternalSchemaDescription instance) {
        if (instance instanceof ImmutableComponentExternalSchemaDescription) {
            return (ImmutableComponentExternalSchemaDescription)instance;
        }
        return ImmutableComponentExternalSchemaDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ComponentExternalSchemaDescription", generator="Immutables")
    private final class InitShim {
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;

        private InitShim() {
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableComponentExternalSchemaDescription.this.getOutputRowStructInitialize(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableComponentExternalSchemaDescription.this.getSchemaFieldDescriptionsMapInitialize(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            return "Cannot build ComponentExternalSchemaDescription, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="ComponentExternalSchemaDescription", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ComponentExternalSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Component.WithSchemaDescription instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 1L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 1L;
                }
            }
            if (object instanceof ComponentExternalSchemaDescription) {
                instance = (ComponentExternalSchemaDescription)object;
                if ((bits & 1L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        public ImmutableComponentExternalSchemaDescription build() {
            return new ImmutableComponentExternalSchemaDescription((ImmutableList<Component.SchemaFieldDescription>)this.schemaFieldDescriptions.build());
        }
    }
}

