/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.input;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.immutables.value.Value;
import org.talend.bigdata.common.input.Reader;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public interface FileReader<T>
extends Reader<T> {
    @Value.Parameter
    public List<String> paths();

    @Value.Derived
    default public URI previousURI() {
        return FileSystem.getDefaultUri((Configuration)this.context().hadoopConfiguration());
    }

    default public Dataset<T> read() throws IOException, URISyntaxException {
        Dataset ds = this.sparkSession().read().options(this.options()).load(((Iterable)JavaConverters.collectionAsScalaIterableConverter(this.paths()).asScala()).toSeq());
        return Row.class.equals(this.rowClass()) ? ds : ds.as(this.encoder());
    }
}

