/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.input;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.talend.bigdata.common.input.AvroRecordInstanceCreationException;

public class FromRowToAvroRecord<U extends SpecificRecordBase>
implements MapFunction<Row, U> {
    private final Class<U> clazz;
    private final boolean mappingWithIndex;

    public FromRowToAvroRecord(Class<U> clazz, boolean mappingWithIndex) {
        this.clazz = clazz;
        this.mappingWithIndex = mappingWithIndex;
    }

    public U call(Row row) {
        SpecificRecordBase result;
        try {
            result = (SpecificRecordBase)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Throwable rootCause = e.getCause();
            throw new AvroRecordInstanceCreationException("Constructor threw an exception in class " + this.clazz.getName() + ": " + rootCause, rootCause);
        }
        StructField[] structFields = row.schema().fields();
        List avroFields = result.getSchema().getFields();
        Map avroFieldsMap = IntStream.range(0, avroFields.size()).boxed().collect(Collectors.toMap(index -> ((Schema.Field)avroFields.get((int)index)).name().toLowerCase(), Function.identity()));
        for (int i = 0; i < structFields.length; ++i) {
            if (avroFieldsMap.containsKey(structFields[i].name().toLowerCase())) {
                result.put(((Integer)avroFieldsMap.get(structFields[i].name().toLowerCase())).intValue(), row.get(i));
                continue;
            }
            if (!this.mappingWithIndex || row.isNullAt(i) || result.get(i) != null) continue;
            result.put(i, row.get(i));
        }
        return (U)result;
    }
}

