/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.jar.JarFile;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.immutables.value.Value;
import org.talend.bigdata.common.storage.ImmutableGoogleStorage;
import org.talend.bigdata.common.storage.Storage;
import org.talend.bigdata.common.utils.storage.StorageUtils;
import scala.Tuple2;

@Value.Enclosing
public interface GoogleStorage
extends Storage {
    public static GoogleCredentials credentials(URI credentialsFile) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (GoogleCredentials)mapper.readValue(new File(credentialsFile.getPath()), ImmutableGoogleStorage.GoogleCredentials.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static GoogleCredentials credentials(String id, SparkSession sparkSession, Class mainClass) {
        if (sparkSession.sparkContext().getConf().contains(id) && Files.exists(Paths.get(sparkSession.sparkContext().getConf().get(id), new String[0]), new LinkOption[0])) {
            try {
                return (GoogleCredentials)new ObjectMapper().readValue(new File(URI.create(sparkSession.sparkContext().getConf().get(id))), ImmutableGoogleStorage.GoogleCredentials.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (GoogleCredentials)new ObjectMapper().readValue(mainClass.getClassLoader().getResource(mainClass.getPackage().getName().replaceAll("\\.", "/") + "/contexts/" + id + ".json"), ImmutableGoogleStorage.GoogleCredentials.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromCredentials(GoogleCredentials credentials) {
        try {
            return new ObjectMapper().writeValueAsString((Object)credentials);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendCredentialToClasspath(SparkConf sparkConf, String jobJar) {
        Tuple2[] entries = sparkConf.getAll();
        if (entries == null) {
            return;
        }
        String appName = sparkConf.get("spark.app.name");
        Arrays.stream(entries).filter(entry -> ((String)entry._1).contains("tGSConfiguration")).forEach(gsConfiguration -> {
            try (FileSystem zipFS = FileSystems.newFileSystem(new URI("jar", Paths.get(jobJar.replace("\\", "/"), new String[0]).toUri().toString(), null), new HashMap());
                 JarFile jar = new JarFile(new File(jobJar));){
                String contextDirectory = jar.stream().filter(jarEntry -> !jarEntry.isDirectory()).map(jarEntry -> URI.create(jarEntry.getName()).getPath()).filter(path -> {
                    String fileName = path.substring(path.lastIndexOf(47) + 1).replaceFirst(".class", "");
                    return appName.contains(fileName);
                }).findFirst().map(path -> path.substring(0, path.lastIndexOf(47)) + "/contexts/").orElse("contexts/");
                Path pathInZipFile = zipFS.getPath(contextDirectory + (String)gsConfiguration._1 + ".json", new String[0]).normalize();
                Path zipRoot = zipFS.getPath("/", new String[0]).normalize();
                if (!pathInZipFile.startsWith(zipRoot)) {
                    throw new IOException("Bad zip entry: " + pathInZipFile);
                }
                Files.copy(new File((String)gsConfiguration._2).toPath(), pathInZipFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String id();

    public String projectId();

    public String bucket();

    public URI credentialsFile();

    @Override
    @Value.Derived
    default public void push(SparkConf sparkConf) {
        File credentials = new File(this.credentialsFile().toString());
        if (StorageUtils.checkIfWindows()) {
            credentials = new File(this.credentialsFile());
        }
        if (credentials.exists()) {
            sparkConf.set(this.id(), credentials.getAbsolutePath());
        }
    }

    @Override
    @Value.Derived
    default public String getFileOnStorage(String folder) {
        return "gs://" + this.bucket() + folder;
    }

    @JsonDeserialize(as=ImmutableGoogleStorage.GoogleCredentials.class)
    @JsonSerialize(as=ImmutableGoogleStorage.GoogleCredentials.class)
    @Value.Immutable
    public static interface GoogleCredentials {
        public String type();

        @JsonProperty(value="project_id")
        public String projectId();

        @JsonProperty(value="private_key_id")
        public String privateKeyId();

        @JsonProperty(value="private_key")
        public String privateKey();

        @JsonProperty(value="client_email")
        public String clientEmail();

        @JsonProperty(value="client_id")
        public String clientId();

        @JsonProperty(value="auth_uri")
        public String authUri();

        @JsonProperty(value="token_uri")
        public String tokenUri();

        @JsonProperty(value="auth_provider_x509_cert_url")
        public String authProviderX509CertUrl();

        @JsonProperty(value="client_x509_cert_url")
        public String clientX509CertUrl();
    }

    @Value.Immutable
    public static interface Configuration
    extends Storage.Configuration {
        public URI bucket();

        @Override
        @Value.Derived
        default public org.apache.hadoop.fs.FileSystem fileSystem() {
            org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
            this.configuration().forEach((arg_0, arg_1) -> ((org.apache.hadoop.conf.Configuration)configuration).set(arg_0, arg_1));
            try {
                return org.apache.hadoop.fs.FileSystem.get((URI)this.bucket(), (org.apache.hadoop.conf.Configuration)configuration);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Value.Immutable
    public static interface WithServiceAccount
    extends GoogleStorage {
        public String accountServiceIdentifier();
    }

    @Value.Immutable
    public static interface Simple
    extends GoogleStorage {
    }
}

