/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.storage;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.tfileoutput.TFileOutputCommon;

public interface Storage
extends Component.SparkConfigurationAware {
    public String getFileOnStorage(String var1);

    public String temporaryFolder();

    public static interface Configuration {
        public Map<String, String> configuration();

        default public FileSystem fileSystem() {
            org.apache.hadoop.conf.Configuration configuration = new org.apache.hadoop.conf.Configuration();
            this.configuration().forEach((arg_0, arg_1) -> ((org.apache.hadoop.conf.Configuration)configuration).set(arg_0, arg_1));
            try {
                return FileSystem.get((org.apache.hadoop.conf.Configuration)configuration);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Value.Derived
        default public void prepare(TFileOutputCommon tFileOutputCommon) {
            try {
                FileSystem fileSystem = this.fileSystem();
                Path filePath = new Path(tFileOutputCommon.file());
                if (!fileSystem.exists(filePath)) {
                    return;
                }
                switch (tFileOutputCommon.fileAction()) {
                    case CREATE: {
                        throw new FileAlreadyExistsException(tFileOutputCommon.file());
                    }
                    case OVERWRITE: {
                        fileSystem.delete(filePath, true);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

