/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.altus.CloudConfiguration;
import org.talend.bigdata.launcher.fs.AzureDataLakeStorage;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.Utils;

public class AzureConfiguration
implements CloudConfiguration {
    private final String account;
    private final String appId;
    private final String appKey;
    private final String authTokenEndPoint;
    private final String remoteFolder = "remoteFolder";
    private final String remoteStatusFolder = "remoteStatusFolder";
    private static Logger ALTUS_LOG = LoggerFactory.getLogger(AzureConfiguration.class);

    public AzureConfiguration(String account, String appId, String authTokenEndPoint, String appKey) {
        this.account = account;
        this.appId = appId;
        this.authTokenEndPoint = authTokenEndPoint;
        this.appKey = appKey;
    }

    @Override
    public List<String> uploadJars(String jobJar, String libJars) {
        ALTUS_LOG.info("Starting to upload job and dependencies into " + this.account);
        ALTUS_LOG.info("jobJar:" + jobJar);
        ALTUS_LOG.info("libjars:" + libJars);
        ArrayList<String> uploadedJars = new ArrayList<String>();
        AzureDataLakeStorage adls = new AzureDataLakeStorage(this.account, this.appId, this.authTokenEndPoint, this.appKey);
        adls.setOverwrite(false);
        String sentFiles = null;
        try {
            sentFiles = Utils.sendFiles((String)this.remoteFolder, (String)this.remoteStatusFolder, (FileSystem)adls, (String)jobJar, (String)libJars);
            uploadedJars.add(Utils.getJobJarUri((String)this.remoteFolder, (String)jobJar, (FileSystem)adls));
            uploadedJars.addAll(Arrays.asList(sentFiles.split(",")));
        }
        catch (IOException | URISyntaxException | InvalidKeyException e) {
            throw new RuntimeException("Failed to upload jars : " + e.getMessage());
        }
        ALTUS_LOG.info("Finish uploading job dependencies into " + this.account);
        return uploadedJars;
    }

    @Override
    public String getSshKeyArg() {
        return "--public-key";
    }

    @Override
    public String getClusterCreationCommand() {
        return "create-azure-cluster";
    }

    @Override
    public String getSshKeyContent(String sshKey) {
        return "file://" + sshKey;
    }

    @Override
    public String getCdhVersion() {
        return "CDH513";
    }
}

