/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.altus.AltusJob;
import org.talend.bigdata.launcher.altus.AltusJobUtil;
import org.talend.bigdata.launcher.altus.CloudConfiguration;

public class AltusSparkJob
extends AltusJob {
    private static Logger SPARK_LOG = LoggerFactory.getLogger(AltusSparkJob.class);

    private AltusSparkJob(String talendJobName, String clusterName, boolean setCredentials, String accessKey, String secretKey, CloudConfiguration cloudConfiguration, String pathToAltusCLI, Map<String, String> conf, String mainClass, String jarToExecute, String libJars, List<String> args, String logLevel) {
        this.talendJobName = talendJobName;
        this.clusterName = clusterName;
        this.setCredentials = setCredentials;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudConfiguration = cloudConfiguration;
        this.pathToAltusCLI = pathToAltusCLI;
        this.conf = conf;
        this.mainClass = mainClass;
        this.jarToExecute = jarToExecute;
        this.libJars = libJars;
        this.args = args;
        if (StringUtils.isNotEmpty((CharSequence)logLevel)) {
            // empty if block
        }
    }

    private void connect() {
        if (this.setCredentials) {
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "configure"});
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                BufferedWriter stdOutput = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
                String secretKeyValue = "";
                if (this.secretKey != null) {
                    try {
                        String sCurrentLine;
                        BufferedReader br = new BufferedReader(new FileReader(this.secretKey));
                        while ((sCurrentLine = br.readLine()) != null) {
                            secretKeyValue = secretKeyValue + sCurrentLine + "\\n";
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        SPARK_LOG.error(e.getMessage());
                    }
                }
                stdOutput.write(this.accessKey);
                stdOutput.newLine();
                stdOutput.write(secretKeyValue.substring(0, secretKeyValue.length() - 2));
                stdOutput.newLine();
                stdOutput.flush();
                stdOutput.close();
                StringBuilder submitJobLog = new StringBuilder();
                String s = null;
                while ((s = stdInput.readLine()) != null) {
                    submitJobLog.append(s);
                    submitJobLog.append("\n");
                }
                if (submitJobLog.length() > 0) {
                    String log = submitJobLog.toString();
                    SPARK_LOG.info(log);
                } else {
                    while ((s = stdError.readLine()) != null) {
                        submitJobLog.append(s);
                        submitJobLog.append("\n");
                    }
                    SPARK_LOG.error(submitJobLog.toString());
                }
                stdInput.close();
                stdError.close();
            }
            catch (IOException e) {
                SPARK_LOG.error("Cannot set Altus credentials:");
                SPARK_LOG.error(e.getMessage());
            }
        }
    }

    private String generateJobArgument(List<String> jarsFileUris) {
        String remoteArgs = AltusJobUtil.prepareArgs(this.args);
        String properties = AltusJobUtil.prepareProperties(this.conf);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < jarsFileUris.size(); ++i) {
            sb.append(AltusJobUtil.wrapEscapeQuote(jarsFileUris.get(i)));
            if (i != jarsFileUris.size() - 1) {
                sb.append(", ");
                continue;
            }
            sb.append("]");
        }
        return "{" + AltusJobUtil.wrapEscapeQuote("name") + ": " + AltusJobUtil.wrapEscapeQuote(this.talendJobName) + "," + AltusJobUtil.wrapEscapeQuote("sparkJob") + ": { " + AltusJobUtil.wrapEscapeQuote("jars") + ": " + sb.toString() + "," + AltusJobUtil.wrapEscapeQuote("applicationArguments") + ":[" + remoteArgs + "]," + AltusJobUtil.wrapEscapeQuote("sparkArguments") + ":" + properties + ", " + AltusJobUtil.wrapEscapeQuote("mainClass") + ":" + AltusJobUtil.wrapEscapeQuote(this.mainClass) + "}}";
    }

    @Override
    protected void execute(List<String> jarsFileUris) throws IOException, GeneralSecurityException {
        this.connect();
        String jobArgument = AltusJobUtil.generateJobArgument(this.talendJobName, this.mainClass, jarsFileUris, this.args, this.conf);
        SPARK_LOG.debug("Executing command line:");
        SPARK_LOG.warn(this.pathToAltusCLI + " dataeng submit-jobs --cluster-name " + this.clusterName + " --jobs " + jobArgument);
        Process p = Runtime.getRuntime().exec(new String[]{this.pathToAltusCLI, "dataeng", "submit-jobs", "--cluster-name", this.clusterName, "--jobs", jobArgument});
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        StringBuilder submitJobLog = new StringBuilder();
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            submitJobLog.append(s);
            submitJobLog.append("\n");
        }
        if (submitJobLog.length() > 0) {
            String log = submitJobLog.toString();
            SPARK_LOG.info(AltusJobUtil.maskAwsAccessSecretKeyInSparkConf(log));
            Matcher matcher = Pattern.compile("\"jobId\": \"([^\"]+)\"").matcher(log);
            if (matcher.find()) {
                this.jobId = matcher.group(1);
            }
        } else {
            while ((s = stdError.readLine()) != null) {
                submitJobLog.append(s);
                submitJobLog.append("\n");
            }
            SPARK_LOG.error(submitJobLog.toString());
        }
        stdInput.close();
        stdError.close();
    }

    public static class Builder {
        protected String serviceAccountCredentialsPath;
        protected String libJars;
        protected String jarToExecute;
        protected String mainClass;
        protected List<String> args;
        protected Map<String, String> conf;
        protected String talendJobName;
        protected String clusterName;
        protected boolean setCredentials = false;
        protected String accessKey;
        protected String secretKey;
        protected String pathToAltusCLI;
        protected String logLevel;
        protected CloudConfiguration cloudConfiguration;

        public Builder withJarToExecute(String jarToExecute) {
            this.jarToExecute = jarToExecute;
            return this;
        }

        public Builder withMainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Builder withLibJars(String libJars) {
            this.libJars = libJars;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.talendJobName = talendJobName;
            return this;
        }

        public Builder setCredentials(boolean setCredentials) {
            this.setCredentials = setCredentials;
            return this;
        }

        public Builder withAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder withSecretKey(String secretKey) {
            this.secretKey = secretKey.replace("\n", "\\n");
            return this;
        }

        public Builder withPathToAltusCLI(String pathToAltusCLI) {
            this.pathToAltusCLI = pathToAltusCLI;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.conf = conf;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withLogLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withCloudConfiguration(CloudConfiguration cloudConfiguration) {
            this.cloudConfiguration = cloudConfiguration;
            return this;
        }

        public AltusSparkJob build() {
            return new AltusSparkJob(this.talendJobName, this.clusterName, this.setCredentials, this.accessKey, this.secretKey, this.cloudConfiguration, this.pathToAltusCLI, this.conf, this.mainClass, this.jarToExecute, this.libJars, this.args, this.logLevel);
        }
    }
}

