/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks.filesystem;

import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.service.files.FileInfo;
import com.databricks.sdk.service.files.ReadDbfsRequest;
import com.databricks.sdk.service.files.ReadResponse;
import com.google.api.client.util.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.databricks.DatabricksLauncherException;
import org.talend.bigdata.launcher.databricks.filesystem.DatabricksFileSystemUtil;

public class DatabricksFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksFileSystem.class);
    private static final long CHUNK_SIZE = 0x100000L;
    private Boolean overwrite;
    public static WorkspaceClient workspace;

    public DatabricksFileSystem(String host, String token) {
        workspace = new WorkspaceClient(new DatabricksConfig().setHost(host).setToken(token));
    }

    public DatabricksFileSystem(String host, String clientID, String secretID) {
        workspace = new WorkspaceClient(new DatabricksConfig().setHost(host).setClientSecret(secretID).setClientId(clientID));
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void copyFromLocal(String localFile, String remoteFile) {
        DatabricksFileSystemUtil.copyFromLocal(workspace, localFile, remoteFile, this.overwrite);
    }

    public FileInfo getStatus(String remoteFile) {
        return workspace.dbfs().getStatus(remoteFile);
    }

    public void copyToLocal(String remoteFile, String localFile) {
        this.copyToLocal(remoteFile, localFile, true);
    }

    public void copyToLocal(String remoteFile, String localFile, boolean localOverwrite) {
        Path localPath = Paths.get(localFile, new String[0]);
        if (localPath.toFile().exists() && !localOverwrite) {
            throw new DatabricksLauncherException("Local file already exists : " + localPath.toAbsolutePath().toString());
        }
        if (!localPath.getParent().toFile().exists() && !localPath.getParent().toFile().mkdirs()) {
            throw new DatabricksLauncherException("Could not create local folder {}" + localPath.getParent().toAbsolutePath().toString());
        }
        try (FileOutputStream fileOutput = new FileOutputStream(localPath.toFile());){
            this.readFile(fileOutput, remoteFile);
        }
        catch (IOException e) {
            throw new DatabricksLauncherException("Unexpected Error: " + e.getMessage(), e);
        }
    }

    private void readFile(OutputStream stream, String filePath) throws IOException {
        long offset = 0L;
        StringBuilder fileContent = new StringBuilder();
        boolean hasMoreData = true;
        while (hasMoreData) {
            ReadResponse response;
            ReadDbfsRequest readRequest = new ReadDbfsRequest().setPath(filePath).setOffset(Long.valueOf(offset)).setLength(Long.valueOf(0x100000L));
            try {
                response = workspace.dbfs().read(readRequest);
            }
            catch (Exception e) {
                LOG.error("Error reading file chunk: ", (Throwable)e);
                throw new DatabricksLauncherException("Failed to read file chunk.", e);
            }
            if (response.getData() != null) {
                byte[] decodedBytes = Base64.getDecoder().decode(response.getData());
                String chunk = new String(decodedBytes, StandardCharsets.UTF_8);
                fileContent.append(chunk);
                long bytesRead = decodedBytes.length;
                if (bytesRead < 0x100000L) {
                    hasMoreData = false;
                    continue;
                }
                offset += bytesRead;
                continue;
            }
            hasMoreData = false;
        }
        stream.write(fileContent.toString().getBytes());
    }

    public List<FileInfo> list(String folder, boolean includeSubDir) {
        ArrayList currentItems = Lists.newArrayList((Iterable)workspace.dbfs().list(folder));
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        if (!includeSubDir) {
            for (FileInfo item : currentItems) {
                if (item.getIsDir().booleanValue()) continue;
                result.add(item);
            }
            return result;
        }
        for (FileInfo item : currentItems) {
            if (item.getIsDir().booleanValue()) {
                result.addAll(this.list(item.getPath(), true));
                continue;
            }
            result.add(item);
        }
        return result;
    }
}

