/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import com.databricks.sdk.service.compute.AutoScale;
import com.databricks.sdk.service.compute.ClusterSpec;
import com.databricks.sdk.service.compute.InitScriptInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.databricks.DatabricksAutoscale;
import org.talend.bigdata.launcher.databricks.DatabricksAwsAttributes;
import org.talend.bigdata.launcher.databricks.DatabricksStorageInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabricksCluster {
    private int numWorkers;
    private DatabricksAutoscale autoscale;
    private String sparkVersion;
    private Map<String, String> sparkConf;
    private DatabricksAwsAttributes awsAttributes;
    private String nodeTypeId;
    private String driverNodeTypeId;
    private List<String> sshPublicKeys;
    private Map<String, String> customTags;
    private DatabricksStorageInfo clusterLogConf;
    private List<DatabricksStorageInfo> initScripts;
    private Boolean enableElasticDisk;
    private String instancePoolId;
    private String singleUserName;
    private String policyId;

    public DatabricksCluster(int numWorkers, DatabricksAutoscale autoscale, String sparkVersion, Map<String, String> sparkConf, DatabricksAwsAttributes awsAttributes, String nodeTypeId, String driverNodeTypeId, List<String> sshPublicKeys, Map<String, String> customTags, DatabricksStorageInfo clusterLogConf, List<DatabricksStorageInfo> initScripts, Boolean enableElasticDisk, String instancePoolId, String singleUserName, String policyId) {
        this.numWorkers = numWorkers;
        this.autoscale = autoscale;
        this.sparkVersion = sparkVersion;
        this.sparkConf = sparkConf;
        this.awsAttributes = awsAttributes;
        this.nodeTypeId = nodeTypeId;
        this.driverNodeTypeId = driverNodeTypeId;
        this.sshPublicKeys = sshPublicKeys;
        this.customTags = customTags;
        this.clusterLogConf = clusterLogConf;
        this.initScripts = initScripts;
        this.enableElasticDisk = enableElasticDisk;
        this.instancePoolId = instancePoolId;
        this.singleUserName = singleUserName;
        this.policyId = policyId;
    }

    public ClusterSpec createClusterSpec() {
        ClusterSpec req = new ClusterSpec().setSparkVersion(this.sparkVersion).setNodeTypeId(this.nodeTypeId);
        req.setNumWorkers(Long.valueOf(this.numWorkers));
        if (this.autoscale != null) {
            req.setAutoscale(new AutoScale().setMaxWorkers(Long.valueOf(this.autoscale.getMaxWorkers())).setMinWorkers(Long.valueOf(this.autoscale.getMinWorkers())));
        }
        if (this.sparkConf != null) {
            req.setSparkConf(this.sparkConf);
        }
        if (this.awsAttributes != null) {
            req.setAwsAttributes(this.awsAttributes.toSdkAwsAttributes());
        }
        if (this.driverNodeTypeId != null) {
            req.setDriverNodeTypeId(this.driverNodeTypeId);
        }
        if (this.sshPublicKeys != null) {
            req.setSshPublicKeys(this.sshPublicKeys);
        }
        if (this.customTags != null) {
            req.setCustomTags(this.customTags);
        }
        if (this.clusterLogConf != null) {
            req.setClusterLogConf(this.clusterLogConf.toClusterLogConf());
        }
        if (this.initScripts != null) {
            List<InitScriptInfo> list = this.initScripts.stream().map(script -> script.toInitScriptInfo()).toList();
            req.setInitScripts(list);
        }
        if (this.enableElasticDisk != null) {
            req.setEnableElasticDisk(this.enableElasticDisk);
        }
        if (this.instancePoolId != null) {
            req.setInstancePoolId(this.instancePoolId);
        }
        if (this.singleUserName != null) {
            req.setSingleUserName(this.singleUserName);
        }
        if (this.policyId != null) {
            req.setPolicyId(this.policyId);
        }
        return req;
    }

    public static class Builder {
        private String sparkVersion;
        private int numWorkers;
        private DatabricksAutoscale autoscale;
        private String driverNodeTyeId;
        private Map<String, String> sparkConf;
        private DatabricksAwsAttributes awsAttributes;
        private String nodeTypeId;
        private List<String> sshPublicKeys;
        private Map<String, String> customTags;
        private DatabricksStorageInfo clusterLogConf;
        private Boolean enableElasticDisk;
        private String instancePoolId;
        private List<DatabricksStorageInfo> initScripts;
        private String singleUserName;
        private String policyId;

        public Builder withNumWorkers(int numWorkers) {
            this.numWorkers = numWorkers;
            return this;
        }

        public Builder withAutoscale(DatabricksAutoscale autoscale) {
            this.autoscale = autoscale;
            return this;
        }

        public Builder withSingleUserName(String singleUserName) {
            this.singleUserName = singleUserName;
            return this;
        }

        public Builder withSparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            return this;
        }

        public Builder withSparkConf(Map<String, String> sparkConf) {
            this.sparkConf = sparkConf;
            return this;
        }

        public Builder withAwsAttributes(DatabricksAwsAttributes awsAttributes) {
            this.awsAttributes = awsAttributes;
            return this;
        }

        public Builder withNodeTypeId(String nodeTypeId) {
            this.nodeTypeId = nodeTypeId;
            return this;
        }

        public Builder withDriverNodeTyeId(String driverNodeTyeId) {
            this.driverNodeTyeId = driverNodeTyeId;
            return this;
        }

        public Builder withInstancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder withSshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        public Builder withCustomTags(Map<String, String> customTags) {
            this.customTags = customTags;
            return this;
        }

        public Builder withClusterLogConf(DatabricksStorageInfo clusterLogConf) {
            this.clusterLogConf = clusterLogConf;
            return this;
        }

        public Builder withInitScripts(List<DatabricksStorageInfo> initScripts) {
            if (this.initScripts == null) {
                this.initScripts = new ArrayList<DatabricksStorageInfo>();
            }
            this.initScripts.addAll(initScripts);
            return this;
        }

        public Builder withEnableElasticDisk(boolean enableElasticDisk) {
            this.enableElasticDisk = enableElasticDisk;
            return this;
        }

        public Builder withPolicyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public DatabricksCluster build() {
            return new DatabricksCluster(this.numWorkers, this.autoscale, this.sparkVersion, this.sparkConf, this.awsAttributes, this.nodeTypeId, this.driverNodeTyeId, this.sshPublicKeys, this.customTags, this.clusterLogConf, this.initScripts, this.enableElasticDisk, this.instancePoolId, this.singleUserName, this.policyId);
        }
    }
}

