/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.cookie;

import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.cookie.CommonCookieAttributeHandler;
import org.talend.bigdata.http.cookie.Cookie;
import org.talend.bigdata.http.cookie.CookieOrigin;
import org.talend.bigdata.http.cookie.CookieRestrictionViolationException;
import org.talend.bigdata.http.cookie.MalformedCookieException;
import org.talend.bigdata.http.cookie.SetCookie;
import org.talend.bigdata.http.impl.cookie.AbstractCookieAttributeHandler;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

