/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.jackson.annotation.JsonGetter;
import org.talend.bigdata.jackson.annotation.JsonInclude;
import org.talend.bigdata.jackson.core.JsonProcessingException;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.launcher.databricks.DatabricksAutoscale;
import org.talend.bigdata.launcher.databricks.DatabricksAwsAttributes;
import org.talend.bigdata.launcher.databricks.DatabricksStorageInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabricksCluster {
    private int numWorkers;
    private DatabricksAutoscale autoscale;
    private String sparkVersion;
    private Map<String, String> sparkConf;
    private DatabricksAwsAttributes awsAttributes;
    private String nodeTypeId;
    private String driverNodeTyeId;
    private List<String> sshPublicKeys;
    private Map<String, String> customTags;
    private DatabricksStorageInfo clusterLogConf;
    private List<DatabricksStorageInfo> initScripts;
    private Boolean enableElasticDisk;
    private String instancePoolId;
    private String singleUserName;
    private String policyId;

    public DatabricksCluster(int numWorkers, DatabricksAutoscale autoscale, String sparkVersion, Map<String, String> sparkConf, DatabricksAwsAttributes awsAttributes, String nodeTypeId, String driverNodeTyeId, List<String> sshPublicKeys, Map<String, String> customTags, DatabricksStorageInfo clusterLogConf, List<DatabricksStorageInfo> initScripts, Boolean enableElasticDisk, String instancePoolId, String singleUserName, String policyId) {
        this.numWorkers = numWorkers;
        this.autoscale = autoscale;
        this.sparkVersion = sparkVersion;
        this.sparkConf = sparkConf;
        this.awsAttributes = awsAttributes;
        this.nodeTypeId = nodeTypeId;
        this.driverNodeTyeId = driverNodeTyeId;
        this.sshPublicKeys = sshPublicKeys;
        this.customTags = customTags;
        this.clusterLogConf = clusterLogConf;
        this.initScripts = initScripts;
        this.enableElasticDisk = enableElasticDisk;
        this.instancePoolId = instancePoolId;
        this.singleUserName = singleUserName;
        this.policyId = policyId;
    }

    @JsonGetter(value="single_user_name")
    public String getSingleUserName() {
        return this.singleUserName;
    }

    @JsonGetter(value="num_workers")
    public int getNumWorkers() {
        return this.numWorkers;
    }

    @JsonGetter(value="autoscale")
    public DatabricksAutoscale getAutoscale() {
        return this.autoscale;
    }

    @JsonGetter(value="spark_version")
    public String getSparkVersion() {
        return this.sparkVersion;
    }

    @JsonGetter(value="spark_conf")
    public Map<String, String> getSparkConf() {
        return this.sparkConf;
    }

    @JsonGetter(value="aws_attributes")
    public DatabricksAwsAttributes getAwsAttributes() {
        return this.awsAttributes;
    }

    @JsonGetter(value="node_type_id")
    public String getNodeTypeId() {
        return this.nodeTypeId;
    }

    @JsonGetter(value="driver_node_type_id")
    public String getDriverNodeTyeId() {
        return this.driverNodeTyeId;
    }

    @JsonGetter(value="ssh_public_keys")
    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    @JsonGetter(value="custom_tags")
    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    @JsonGetter(value="cluster_log_conf")
    public DatabricksStorageInfo getClusterLogConf() {
        return this.clusterLogConf;
    }

    @JsonGetter(value="init_scripts")
    public List<DatabricksStorageInfo> getInitScripts() {
        return this.initScripts;
    }

    @JsonGetter(value="enable_elastic_disk")
    public Boolean isEnableElasticDisk() {
        return this.enableElasticDisk;
    }

    @JsonGetter(value="instance_pool_id")
    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    @JsonGetter(value="policy_id")
    public String getPolicyId() {
        return this.policyId;
    }

    public String toJson() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.toJson();
    }

    public static class Builder {
        private String sparkVersion;
        private int numWorkers;
        private DatabricksAutoscale autoscale;
        private String driverNodeTyeId;
        private Map<String, String> sparkConf;
        private DatabricksAwsAttributes awsAttributes;
        private String nodeTypeId;
        private List<String> sshPublicKeys;
        private Map<String, String> customTags;
        private DatabricksStorageInfo clusterLogConf;
        private Boolean enableElasticDisk;
        private String instancePoolId;
        private List<DatabricksStorageInfo> initScripts;
        private String singleUserName;
        private String policyId;

        public Builder withNumWorkers(int numWorkers) {
            this.numWorkers = numWorkers;
            return this;
        }

        public Builder withAutoscale(DatabricksAutoscale autoscale) {
            this.autoscale = autoscale;
            return this;
        }

        public Builder withSingleUserName(String singleUserName) {
            this.singleUserName = singleUserName;
            return this;
        }

        public Builder withSparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            return this;
        }

        public Builder withSparkConf(Map<String, String> sparkConf) {
            this.sparkConf = sparkConf;
            return this;
        }

        public Builder withAwsAttributes(DatabricksAwsAttributes awsAttributes) {
            this.awsAttributes = awsAttributes;
            return this;
        }

        public Builder withNodeTypeId(String nodeTypeId) {
            this.nodeTypeId = nodeTypeId;
            return this;
        }

        public Builder withDriverNodeTyeId(String driverNodeTyeId) {
            this.driverNodeTyeId = driverNodeTyeId;
            return this;
        }

        public Builder withInstancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder withSshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        public Builder withCustomTags(Map<String, String> customTags) {
            this.customTags = customTags;
            return this;
        }

        public Builder withClusterLogConf(DatabricksStorageInfo clusterLogConf) {
            this.clusterLogConf = clusterLogConf;
            return this;
        }

        public Builder withInitScripts(List<DatabricksStorageInfo> initScripts) {
            if (this.initScripts == null) {
                this.initScripts = initScripts;
            } else {
                this.initScripts.addAll(initScripts);
            }
            return this;
        }

        public Builder withEnableElasticDisk(boolean enableElasticDisk) {
            this.enableElasticDisk = enableElasticDisk;
            return this;
        }

        public Builder withPolicyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public DatabricksCluster build() {
            return new DatabricksCluster(this.numWorkers, this.autoscale, this.sparkVersion, this.sparkConf, this.awsAttributes, this.nodeTypeId, this.driverNodeTyeId, this.sshPublicKeys, this.customTags, this.clusterLogConf, this.initScripts, this.enableElasticDisk, this.instancePoolId, this.singleUserName, this.policyId);
        }
    }
}

