/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import org.talend.bigdata.jackson.annotation.JsonGetter;
import org.talend.bigdata.jackson.annotation.JsonInclude;
import org.talend.bigdata.launcher.databricks.DatabricksStorageDestination;
import org.talend.bigdata.launcher.databricks.DatabricksStorageDestinationS3;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatabricksStorageInfo {
    private DatabricksStorageDestinationS3 s3;
    private DatabricksStorageDestination workspace;
    private DatabricksStorageDestination dbfs;

    public DatabricksStorageInfo(String destination) {
        this.workspace = new DatabricksStorageDestination(destination);
    }

    public DatabricksStorageInfo(DatabricksStorageDestinationS3 s3Destination) {
        this.s3 = s3Destination;
    }

    public DatabricksStorageInfo(String destination, DatabricksStorageTypeEnum type) {
        if (DatabricksStorageTypeEnum.WORKSPACE.equals((Object)type)) {
            this.workspace = new DatabricksStorageDestination(destination);
        } else if (DatabricksStorageTypeEnum.DBFS.equals((Object)type)) {
            this.dbfs = new DatabricksStorageDestination(destination);
        }
    }

    @JsonGetter(value="s3")
    public DatabricksStorageDestinationS3 getS3() {
        return this.s3;
    }

    @JsonGetter(value="workspace")
    public DatabricksStorageDestination getWorkspace() {
        return this.workspace;
    }

    @JsonGetter(value="dbfs")
    public DatabricksStorageDestination getDbfs() {
        return this.dbfs;
    }

    public static enum DatabricksStorageTypeEnum {
        WORKSPACE("workspace"),
        S3("s3"),
        DBFS("dbfs");

        private final String json;

        private DatabricksStorageTypeEnum(String json) {
            this.json = json;
        }

        public String toJson() {
            return this.json;
        }
    }
}

