/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.codec.binary.Base64;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.entity.StringEntity;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.jackson.annotation.JsonInclude;
import org.talend.bigdata.jackson.core.Base64Variants;
import org.talend.bigdata.jackson.databind.DeserializationFeature;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.launcher.databricks.api.workspace.Endpoints;
import org.talend.bigdata.launcher.fs.DatabricksFileSystem;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public class DatabricksWSFileSystem
extends DatabricksFileSystem {
    public final String endpoint;
    public final String token;
    public final String userAgent;
    protected static final Logger LOG = LoggerFactory.getLogger(DatabricksWSFileSystem.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public DatabricksWSFileSystem(String endpoint, String token, String userAgent, boolean overwrite, CloseableHttpClient httpClient) {
        super(endpoint, token, userAgent);
        this.endpoint = endpoint;
        this.token = token;
        this.userAgent = userAgent;
        this.overwrite = overwrite;
        this.httpClient = httpClient;
    }

    public DatabricksWSFileSystem(String endpoint, String token, String userAgent, boolean overwrite) {
        this(endpoint, token, userAgent, overwrite, HttpClientBuilder.create().build());
    }

    public void copyFromLocalToWS(String localFile, String path, String folderPath) throws IOException {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS).setBase64Variant(Base64Variants.MIME_NO_LINEFEEDS);
        File file = new File(localFile);
        byte[] bytes = DatabricksWSFileSystem.loadFile(file);
        byte[] encoded = Base64.encodeBase64(bytes);
        String encodedJar = new String(encoded);
        this.mkdir(folderPath);
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("path", path);
            node.put("format", "AUTO");
            node.put("overwrite", this.overwrite);
            node.put("content", encodedJar);
            String url = this.endpoint + "/api/2.0/workspace/import";
            URI apiEndpoint = new URI(url);
            Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            LOG.debug("Creating file at {} with body request {} and response code {} ", new Object[]{url, this.mapper.writeValueAsString(node), response.getStatusLine().getStatusCode()});
        }
        catch (IOException | URISyntaxException e) {
            throw new BigDataLauncherException(String.format("Error creating file at '%s'", path), e);
        }
    }

    private static byte[] loadFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        try {
            for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        catch (IOException e) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        finally {
            ((InputStream)is).close();
        }
        return bytes;
    }

    @Override
    public List<DatabricksFileSystem.FileInfo> list(String folder, boolean includeSubDir) throws BigDataLauncherException {
        try {
            URI uri = this.createURIBuilder(this.endpoint, Endpoints.LIST).setParameter("path", folder).build();
            return this.getFileInfoList(uri, includeSubDir);
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote folder '%s'", folder), e);
        }
    }

    @Override
    public void mkdir(String path) {
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("path", path);
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.MKDIRS).build();
            Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            LOG.debug("Create a directory {} at {} with response {}", new Object[]{this.mapper.writeValueAsString(node), path, response.getStatusLine().getStatusCode()});
        }
        catch (IOException | URISyntaxException e) {
            throw new BigDataLauncherException(String.format("Error getting content of file in workspace '%s'", path), e);
        }
    }
}

