/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.commons;

import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.ProxyConfig;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.utils.CustomCloseInputStream;
import com.databricks.sdk.core.utils.ProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpEntity;
import org.talend.bigdata.http.HttpHost;
import org.talend.bigdata.http.HttpRequest;
import org.talend.bigdata.http.NameValuePair;
import org.talend.bigdata.http.StatusLine;
import org.talend.bigdata.http.client.HttpRequestRetryHandler;
import org.talend.bigdata.http.client.config.RequestConfig;
import org.talend.bigdata.http.client.methods.CloseableHttpResponse;
import org.talend.bigdata.http.client.methods.HttpDelete;
import org.talend.bigdata.http.client.methods.HttpEntityEnclosingRequestBase;
import org.talend.bigdata.http.client.methods.HttpGet;
import org.talend.bigdata.http.client.methods.HttpHead;
import org.talend.bigdata.http.client.methods.HttpPatch;
import org.talend.bigdata.http.client.methods.HttpPost;
import org.talend.bigdata.http.client.methods.HttpPut;
import org.talend.bigdata.http.client.methods.HttpRequestBase;
import org.talend.bigdata.http.client.methods.HttpUriRequest;
import org.talend.bigdata.http.conn.ssl.SSLConnectionSocketFactory;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.entity.InputStreamEntity;
import org.talend.bigdata.http.entity.StringEntity;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.http.impl.conn.PoolingHttpClientConnectionManager;
import org.talend.bigdata.http.protocol.BasicHttpContext;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.io.IOUtils;

public class CommonsHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClient.class);
    private final CloseableHttpClient hc;

    private CommonsHttpClient(Builder builder) {
        int timeoutSeconds = 300;
        if (builder.databricksConfig != null && builder.databricksConfig.getHttpTimeoutSeconds() != null) {
            timeoutSeconds = builder.databricksConfig.getHttpTimeoutSeconds();
        }
        if (builder.timeoutSeconds != null) {
            timeoutSeconds = builder.timeoutSeconds;
        }
        int timeout = timeoutSeconds * 1000;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(this.makeRequestConfig(timeout));
        if (builder.proxyConfig != null) {
            ProxyUtils.setupProxy(builder.proxyConfig, httpClientBuilder);
        }
        if (builder.sslSocketFactory != null) {
            httpClientBuilder.setSSLSocketFactory(builder.sslSocketFactory);
        }
        if (builder.connectionManager != null) {
            httpClientBuilder.setConnectionManager(builder.connectionManager);
        } else {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(20);
            httpClientBuilder.setConnectionManager(connectionManager);
        }
        if (builder.requestRetryHandler != null) {
            httpClientBuilder.setRetryHandler(builder.requestRetryHandler);
        }
        this.hc = httpClientBuilder.build();
    }

    private RequestConfig makeRequestConfig(int timeout) {
        return RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
    }

    @Override
    public Response execute(Request in) throws IOException {
        HttpUriRequest request = this.transformRequest(in);
        boolean handleRedirects = in.getRedirectionBehavior().orElse(true);
        if (!handleRedirects) {
            request.getParams().setParameter("http.protocol.handle-redirects", false);
        }
        in.getHeaders().forEach(request::setHeader);
        BasicHttpContext context = new BasicHttpContext();
        CloseableHttpResponse response = this.hc.execute(request, context);
        return this.computeResponse(in, context, response);
    }

    private URL getTargetUrl(HttpContext context) {
        try {
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            URI uri = new URI(request.getRequestLine().getUri());
            uri = new URI(targetHost.getSchemeName(), null, targetHost.getHostName(), targetHost.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new DatabricksException("Unable to get target URL", e);
        }
    }

    /*
     * Loose catch block
     */
    private Response computeResponse(Request in, HttpContext context, CloseableHttpResponse response) throws IOException {
        boolean streamResponse;
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        Map<String, List<String>> hs = Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
        URL url = this.getTargetUrl(context);
        if (entity == null) {
            response.close();
            return new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs);
        }
        boolean bl = streamResponse = in.getHeaders().containsKey("Accept") && !ContentType.APPLICATION_JSON.getMimeType().equals(in.getHeaders().get("Accept")) && !ContentType.APPLICATION_JSON.getMimeType().equals(response.getFirstHeader("Content-Type").getValue());
        if (streamResponse) {
            CustomCloseInputStream inputStream = new CustomCloseInputStream(entity.getContent(), () -> {
                try {
                    response.close();
                }
                catch (Exception e) {
                    throw new DatabricksException("Unable to close connection", e);
                }
            });
            return new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, inputStream);
        }
        try {
            try (InputStream inputStream = entity.getContent();){
                String body = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
                Response response2 = new Response(in, url, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, body);
                return response2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            response.close();
        }
    }

    private HttpUriRequest transformRequest(Request in) {
        switch (in.getMethod()) {
            case "GET": {
                return new HttpGet(in.getUri());
            }
            case "HEAD": {
                return new HttpHead(in.getUri());
            }
            case "DELETE": {
                return new HttpDelete(in.getUri());
            }
            case "POST": {
                return this.withEntity(new HttpPost(in.getUri()), in);
            }
            case "PUT": {
                return this.withEntity(new HttpPut(in.getUri()), in);
            }
            case "PATCH": {
                return this.withEntity(new HttpPatch(in.getUri()), in);
            }
        }
        throw new IllegalArgumentException("Unknown method: " + in.getMethod());
    }

    private HttpRequestBase withEntity(HttpEntityEnclosingRequestBase request, Request in) {
        if (in.isBodyString()) {
            request.setEntity(new StringEntity(in.getBodyString(), StandardCharsets.UTF_8));
        } else if (in.isBodyStreaming()) {
            request.setEntity(new InputStreamEntity(in.getBodyStream()));
        } else {
            LOG.warn("withEntity called with a request with no body, so no request entity will be set. URI: {}", (Object)in.getUri());
        }
        return request;
    }

    public static class Builder {
        private DatabricksConfig databricksConfig;
        private Integer timeoutSeconds;
        private ProxyConfig proxyConfig;
        private SSLConnectionSocketFactory sslSocketFactory;
        private PoolingHttpClientConnectionManager connectionManager;
        private HttpRequestRetryHandler requestRetryHandler;

        public Builder withDatabricksConfig(DatabricksConfig databricksConfig) {
            this.databricksConfig = databricksConfig;
            return this;
        }

        public Builder withTimeoutSeconds(int timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder withProxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder withSslSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder withConnectionManager(PoolingHttpClientConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        public Builder withRequestRetryHandler(HttpRequestRetryHandler requestRetryHandler) {
            this.requestRetryHandler = requestRetryHandler;
            return this;
        }

        public CommonsHttpClient build() {
            return new CommonsHttpClient(this);
        }
    }
}

