/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateExternalLocation;
import com.databricks.sdk.service.catalog.DeleteExternalLocationRequest;
import com.databricks.sdk.service.catalog.ExternalLocationInfo;
import com.databricks.sdk.service.catalog.ExternalLocationsService;
import com.databricks.sdk.service.catalog.GetExternalLocationRequest;
import com.databricks.sdk.service.catalog.ListExternalLocationsRequest;
import com.databricks.sdk.service.catalog.ListExternalLocationsResponse;
import com.databricks.sdk.service.catalog.UpdateExternalLocation;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ExternalLocationsImpl
implements ExternalLocationsService {
    private final ApiClient apiClient;

    public ExternalLocationsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ExternalLocationInfo create(CreateExternalLocation request) {
        String path = "/api/2.1/unity-catalog/external-locations";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ExternalLocationInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteExternalLocationRequest request) {
        String path = String.format("/api/2.1/unity-catalog/external-locations/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExternalLocationInfo get(GetExternalLocationRequest request) {
        String path = String.format("/api/2.1/unity-catalog/external-locations/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ExternalLocationInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListExternalLocationsResponse list(ListExternalLocationsRequest request) {
        String path = "/api/2.1/unity-catalog/external-locations";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListExternalLocationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExternalLocationInfo update(UpdateExternalLocation request) {
        String path = String.format("/api/2.1/unity-catalog/external-locations/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ExternalLocationInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

