/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.iam.CreateGroupRequest;
import com.databricks.sdk.service.iam.DeleteGroupRequest;
import com.databricks.sdk.service.iam.GetGroupRequest;
import com.databricks.sdk.service.iam.Group;
import com.databricks.sdk.service.iam.GroupsV2Service;
import com.databricks.sdk.service.iam.ListGroupsRequest;
import com.databricks.sdk.service.iam.ListGroupsResponse;
import com.databricks.sdk.service.iam.PatchGroupRequest;
import com.databricks.sdk.service.iam.UpdateGroupRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class GroupsV2Impl
implements GroupsV2Service {
    private final ApiClient apiClient;

    public GroupsV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Group create(CreateGroupRequest request) {
        String path = "/api/2.0/preview/scim/v2/Groups";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Group.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteGroupRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Groups/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Group get(GetGroupRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Groups/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Group.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListGroupsResponse list(ListGroupsRequest request) {
        String path = "/api/2.0/preview/scim/v2/Groups";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListGroupsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PatchGroupRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Groups/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateGroupRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Groups/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

