/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.sql.CreateWarehouseRequest;
import com.databricks.sdk.service.sql.CreateWarehouseResponse;
import com.databricks.sdk.service.sql.DeleteWarehouseRequest;
import com.databricks.sdk.service.sql.EditWarehouseRequest;
import com.databricks.sdk.service.sql.EndpointInfo;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsRequest;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsResponse;
import com.databricks.sdk.service.sql.GetWarehousePermissionsRequest;
import com.databricks.sdk.service.sql.GetWarehouseRequest;
import com.databricks.sdk.service.sql.GetWarehouseResponse;
import com.databricks.sdk.service.sql.GetWorkspaceWarehouseConfigResponse;
import com.databricks.sdk.service.sql.ListWarehousesRequest;
import com.databricks.sdk.service.sql.ListWarehousesResponse;
import com.databricks.sdk.service.sql.SetWorkspaceWarehouseConfigRequest;
import com.databricks.sdk.service.sql.StartRequest;
import com.databricks.sdk.service.sql.State;
import com.databricks.sdk.service.sql.StopRequest;
import com.databricks.sdk.service.sql.WarehousePermissions;
import com.databricks.sdk.service.sql.WarehousePermissionsRequest;
import com.databricks.sdk.service.sql.WarehousesImpl;
import com.databricks.sdk.service.sql.WarehousesService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WarehousesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WarehousesAPI.class);
    private final WarehousesService impl;

    public WarehousesAPI(ApiClient apiClient) {
        this.impl = new WarehousesImpl(apiClient);
    }

    public WarehousesAPI(WarehousesService mock) {
        this.impl = mock;
    }

    public GetWarehouseResponse waitGetWarehouseRunning(String id) throws TimeoutException {
        return this.waitGetWarehouseRunning(id, Duration.ofMinutes(20L), null);
    }

    public GetWarehouseResponse waitGetWarehouseRunning(String id, Duration timeout, Consumer<GetWarehouseResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<State> targetStates = Arrays.asList(State.RUNNING);
        List<State> failureStates = Arrays.asList(State.STOPPED, State.DELETED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            GetWarehouseResponse poll = this.get(new GetWarehouseRequest().setId(id));
            State status = poll.getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getHealth() != null) {
                statusMessage = poll.getHealth().getSummary();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach RUNNING, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("id=%s", id);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public GetWarehouseResponse waitGetWarehouseStopped(String id) throws TimeoutException {
        return this.waitGetWarehouseStopped(id, Duration.ofMinutes(20L), null);
    }

    public GetWarehouseResponse waitGetWarehouseStopped(String id, Duration timeout, Consumer<GetWarehouseResponse> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<State> targetStates = Arrays.asList(State.STOPPED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            GetWarehouseResponse poll = this.get(new GetWarehouseRequest().setId(id));
            State status = poll.getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getHealth() != null) {
                statusMessage = poll.getHealth().getSummary();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            String prefix = String.format("id=%s", id);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<GetWarehouseResponse, CreateWarehouseResponse> create(CreateWarehouseRequest request) {
        CreateWarehouseResponse response = this.impl.create(request);
        return new Wait<GetWarehouseResponse, CreateWarehouseResponse>((timeout, callback) -> this.waitGetWarehouseRunning(response.getId(), timeout, callback), response);
    }

    public void delete(String id) {
        this.delete(new DeleteWarehouseRequest().setId(id));
    }

    public void delete(DeleteWarehouseRequest request) {
        this.impl.delete(request);
    }

    public Wait<GetWarehouseResponse, Void> edit(EditWarehouseRequest request) {
        this.impl.edit(request);
        return new Wait<GetWarehouseResponse, Void>((timeout, callback) -> this.waitGetWarehouseRunning(request.getId(), timeout, callback));
    }

    public GetWarehouseResponse get(String id) {
        return this.get(new GetWarehouseRequest().setId(id));
    }

    public GetWarehouseResponse get(GetWarehouseRequest request) {
        return this.impl.get(request);
    }

    public GetWarehousePermissionLevelsResponse getPermissionLevels(String warehouseId) {
        return this.getPermissionLevels(new GetWarehousePermissionLevelsRequest().setWarehouseId(warehouseId));
    }

    public GetWarehousePermissionLevelsResponse getPermissionLevels(GetWarehousePermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public WarehousePermissions getPermissions(String warehouseId) {
        return this.getPermissions(new GetWarehousePermissionsRequest().setWarehouseId(warehouseId));
    }

    public WarehousePermissions getPermissions(GetWarehousePermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public GetWorkspaceWarehouseConfigResponse getWorkspaceWarehouseConfig() {
        return this.impl.getWorkspaceWarehouseConfig();
    }

    public Iterable<EndpointInfo> list(ListWarehousesRequest request) {
        return new Paginator(request, this.impl::list, ListWarehousesResponse::getWarehouses, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public WarehousePermissions setPermissions(WarehousePermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public void setWorkspaceWarehouseConfig(SetWorkspaceWarehouseConfigRequest request) {
        this.impl.setWorkspaceWarehouseConfig(request);
    }

    public Wait<GetWarehouseResponse, Void> start(StartRequest request) {
        this.impl.start(request);
        return new Wait<GetWarehouseResponse, Void>((timeout, callback) -> this.waitGetWarehouseRunning(request.getId(), timeout, callback));
    }

    public Wait<GetWarehouseResponse, Void> stop(StopRequest request) {
        this.impl.stop(request);
        return new Wait<GetWarehouseResponse, Void>((timeout, callback) -> this.waitGetWarehouseStopped(request.getId(), timeout, callback));
    }

    public WarehousePermissions updatePermissions(WarehousePermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public WarehousesService impl() {
        return this.impl;
    }
}

