/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.text.lookup.AbstractPathFencedLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;
import org.talend.bigdata.lang3.StringUtils;
import org.xml.sax.InputSource;

final class XmlStringLookup
extends AbstractPathFencedLookup {
    static final Map<String, Boolean> DEFAULT_FEATURES = new HashMap<String, Boolean>(1);
    static final XmlStringLookup INSTANCE;
    private final Map<String, Boolean> xPathFactoryFeatures;

    XmlStringLookup(Map<String, Boolean> xPathFactoryFeatures, Path ... fences) {
        super(fences);
        this.xPathFactoryFeatures = Objects.requireNonNull(xPathFactoryFeatures, "xPathFfactoryFeatures");
    }

    @Override
    public String lookup(String key) {
        String string;
        block11: {
            if (key == null) {
                return null;
            }
            String[] keys = key.split(SPLIT_STR);
            int keyLen = keys.length;
            if (keyLen != 2) {
                throw IllegalArgumentExceptions.format("Bad XML key format [%s]; expected format is DocumentPath:XPath.", key);
            }
            String documentPath = keys[0];
            String xpath = StringUtils.substringAfter(key, 58);
            InputStream inputStream = Files.newInputStream(this.getPath(documentPath), new OpenOption[0]);
            try {
                XPathFactory factory = XPathFactory.newInstance();
                for (Map.Entry<String, Boolean> p : this.xPathFactoryFeatures.entrySet()) {
                    factory.setFeature(p.getKey(), p.getValue());
                }
                string = factory.newXPath().evaluate(xpath, new InputSource(inputStream));
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw IllegalArgumentExceptions.format(e, "Error looking up XML document [%s] and XPath [%s].", documentPath, xpath);
                }
            }
            inputStream.close();
        }
        return string;
    }

    static {
        DEFAULT_FEATURES.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        INSTANCE = new XmlStringLookup(DEFAULT_FEATURES, (Path[])null);
    }
}

