/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.talend.bigdata.google.api.client.http.GenericUrl;
import org.talend.bigdata.google.api.client.http.HttpRequest;
import org.talend.bigdata.google.api.client.http.HttpResponse;
import org.talend.bigdata.google.api.client.http.HttpTransport;
import org.talend.bigdata.google.api.client.http.json.JsonHttpContent;
import org.talend.bigdata.google.api.client.json.GenericJson;
import org.talend.bigdata.google.api.client.json.JsonObjectParser;
import org.talend.bigdata.google.api.client.util.GenericData;
import org.talend.bigdata.google.auth.Credentials;
import org.talend.bigdata.google.auth.ServiceAccountSigner;
import org.talend.bigdata.google.auth.http.HttpCredentialsAdapter;
import org.talend.bigdata.google.auth.oauth2.IdToken;
import org.talend.bigdata.google.auth.oauth2.OAuth2Utils;
import org.talend.bigdata.google.common.io.BaseEncoding;

class IamUtils {
    private static final String SIGN_BLOB_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
    private static final String ID_TOKEN_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateIdToken";
    private static final String PARSE_ERROR_MESSAGE = "Error parsing error message response. ";
    private static final String PARSE_ERROR_SIGNATURE = "Error parsing signature response. ";

    IamUtils() {
    }

    static byte[] sign(String serviceAccountEmail, Credentials credentials, HttpTransport transport, byte[] toSign, Map<String, ?> additionalFields) {
        String signature;
        BaseEncoding base64 = BaseEncoding.base64();
        try {
            signature = IamUtils.getSignature(serviceAccountEmail, credentials, transport, base64.encode(toSign), additionalFields);
        }
        catch (IOException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
        }
        return base64.decode(signature);
    }

    private static String getSignature(String serviceAccountEmail, Credentials credentials, HttpTransport transport, String bytes, Map<String, ?> additionalFields) throws IOException {
        String signBlobUrl = String.format(SIGN_BLOB_URL_FORMAT, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(signBlobUrl);
        GenericData signRequest = new GenericData();
        signRequest.set("payload", bytes);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            signRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent signContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, signRequest);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(credentials);
        HttpRequest request = transport.createRequestFactory(adapter).buildPostRequest(genericUrl, signContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = response.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap(responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to sign provided bytes: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to sign provided bytes: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from sign blob server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        return OAuth2Utils.validateString(responseData, "signedBlob", PARSE_ERROR_SIGNATURE);
    }

    static IdToken getIdToken(String serviceAccountEmail, Credentials credentials, HttpTransport transport, String targetAudience, boolean includeEmail, Map<String, ?> additionalFields) throws IOException {
        String idTokenUrl = String.format(ID_TOKEN_URL_FORMAT, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(idTokenUrl);
        GenericData idTokenRequest = new GenericData();
        idTokenRequest.set("audience", targetAudience);
        idTokenRequest.set("includeEmail", includeEmail);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            idTokenRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent idTokenContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, idTokenRequest);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(credentials);
        HttpRequest request = transport.createRequestFactory(adapter).buildPostRequest(genericUrl, idTokenContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = response.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap(responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to getIDToken: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to getIDToken: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from generateIDToken server request.");
        }
        GenericJson responseData = response.parseAs(GenericJson.class);
        String rawToken = OAuth2Utils.validateString(responseData, "token", PARSE_ERROR_MESSAGE);
        return IdToken.create(rawToken);
    }
}

