/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.talend.bigdata.google.api.client.util.Clock;
import org.talend.bigdata.google.auth.Credentials;
import org.talend.bigdata.google.auth.RequestMetadataCallback;
import org.talend.bigdata.google.auth.oauth2.AccessToken;
import org.talend.bigdata.google.common.annotations.VisibleForTesting;
import org.talend.bigdata.google.common.base.MoreObjects;
import org.talend.bigdata.google.common.base.Preconditions;
import org.talend.bigdata.google.common.collect.ImmutableList;
import org.talend.bigdata.google.common.collect.ImmutableMap;
import org.talend.bigdata.google.common.collect.Iterables;
import org.talend.bigdata.google.common.util.concurrent.AbstractFuture;
import org.talend.bigdata.google.common.util.concurrent.FutureCallback;
import org.talend.bigdata.google.common.util.concurrent.Futures;
import org.talend.bigdata.google.common.util.concurrent.ListenableFuture;
import org.talend.bigdata.google.common.util.concurrent.ListenableFutureTask;
import org.talend.bigdata.google.common.util.concurrent.MoreExecutors;
import org.talend.bigdata.javax.annotation.Nullable;

public class OAuth2Credentials
extends Credentials {
    private static final long serialVersionUID = 4556936364828217687L;
    static final Duration DEFAULT_EXPIRATION_MARGIN = Duration.ofMinutes(5L);
    static final Duration DEFAULT_REFRESH_MARGIN = Duration.ofMinutes(6L);
    private static final ImmutableMap<String, List<String>> EMPTY_EXTRA_HEADERS = ImmutableMap.of();
    private final Duration expirationMargin;
    private final Duration refreshMargin;
    @VisibleForTesting
    final Object lock = new byte[0];
    private volatile OAuthValue value = null;
    @VisibleForTesting
    transient RefreshTask refreshTask;
    private transient List<CredentialsChangedListener> changeListeners;
    @VisibleForTesting
    transient Clock clock = Clock.SYSTEM;

    public static OAuth2Credentials create(AccessToken accessToken) {
        return OAuth2Credentials.newBuilder().setAccessToken(accessToken).build();
    }

    protected OAuth2Credentials() {
        this(null);
    }

    protected OAuth2Credentials(AccessToken accessToken) {
        this(accessToken, DEFAULT_REFRESH_MARGIN, DEFAULT_EXPIRATION_MARGIN);
    }

    protected OAuth2Credentials(AccessToken accessToken, Duration refreshMargin, Duration expirationMargin) {
        if (accessToken != null) {
            this.value = OAuthValue.create(accessToken, EMPTY_EXTRA_HEADERS);
        }
        this.refreshMargin = Preconditions.checkNotNull(refreshMargin, "refreshMargin");
        Preconditions.checkArgument(!refreshMargin.isNegative(), "refreshMargin can't be negative");
        this.expirationMargin = Preconditions.checkNotNull(expirationMargin, "expirationMargin");
        Preconditions.checkArgument(!expirationMargin.isNegative(), "expirationMargin can't be negative");
    }

    @Override
    public String getAuthenticationType() {
        return "OAuth2";
    }

    @Override
    public boolean hasRequestMetadata() {
        return true;
    }

    @Override
    public boolean hasRequestMetadataOnly() {
        return true;
    }

    public final AccessToken getAccessToken() {
        OAuthValue localState = this.value;
        if (localState != null) {
            return localState.temporaryAccess;
        }
        return null;
    }

    @VisibleForTesting
    Duration getRefreshMargin() {
        return this.refreshMargin;
    }

    @VisibleForTesting
    Duration getExpirationMargin() {
        return this.expirationMargin;
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, RequestMetadataCallback callback) {
        Futures.addCallback(this.asyncFetch(executor), new FutureCallbackToMetadataCallbackAdapter(callback), MoreExecutors.directExecutor());
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        return OAuth2Credentials.unwrapDirectFuture(this.asyncFetch(MoreExecutors.directExecutor())).requestMetadata;
    }

    @Override
    public void refresh() throws IOException {
        AsyncRefreshResult refreshResult = this.getOrCreateRefreshTask();
        refreshResult.executeIfNew(MoreExecutors.directExecutor());
        OAuth2Credentials.unwrapDirectFuture(refreshResult.task);
    }

    public void refreshIfExpired() throws IOException {
        OAuth2Credentials.unwrapDirectFuture(this.asyncFetch(MoreExecutors.directExecutor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<OAuthValue> asyncFetch(Executor executor) {
        AsyncRefreshResult refreshResult = null;
        if (this.getState() == CacheState.FRESH) {
            return Futures.immediateFuture(this.value);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.getState() != CacheState.FRESH) {
                refreshResult = this.getOrCreateRefreshTask();
            }
        }
        if (refreshResult != null) {
            refreshResult.executeIfNew(executor);
        }
        object = this.lock;
        synchronized (object) {
            if (this.getState() != CacheState.EXPIRED) {
                return Futures.immediateFuture(this.value);
            }
            if (refreshResult != null) {
                return refreshResult.task;
            }
            return Futures.immediateFailedFuture(new IllegalStateException("Credentials expired, but there is no task to refresh"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncRefreshResult getOrCreateRefreshTask() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refreshTask != null) {
                return new AsyncRefreshResult(this.refreshTask, false);
            }
            ListenableFutureTask<OAuthValue> task = ListenableFutureTask.create(new Callable<OAuthValue>(){

                @Override
                public OAuthValue call() throws Exception {
                    return OAuthValue.create(OAuth2Credentials.this.refreshAccessToken(), OAuth2Credentials.this.getAdditionalHeaders());
                }
            });
            this.refreshTask = new RefreshTask(task, new RefreshTaskListener(task));
            return new AsyncRefreshResult(this.refreshTask, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRefreshAsync(ListenableFuture<OAuthValue> finishedTask) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.value = Futures.getDone(finishedTask);
                for (CredentialsChangedListener listener : this.changeListeners) {
                    listener.onChanged(this);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.refreshTask != null && this.refreshTask.getTask() == finishedTask) {
                    this.refreshTask = null;
                }
            }
        }
    }

    private static <T> T unwrapDirectFuture(ListenableFuture<T> future) throws IOException {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while asynchronously refreshing the access token", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IOException("Unexpected error refreshing access token", cause);
        }
    }

    private CacheState getState() {
        OAuthValue localValue = this.value;
        if (localValue == null) {
            return CacheState.EXPIRED;
        }
        Date expirationTime = localValue.temporaryAccess.getExpirationTime();
        if (expirationTime == null) {
            return CacheState.FRESH;
        }
        Duration remaining = Duration.ofMillis(expirationTime.getTime() - this.clock.currentTimeMillis());
        if (remaining.compareTo(this.expirationMargin) <= 0) {
            return CacheState.EXPIRED;
        }
        if (remaining.compareTo(this.refreshMargin) <= 0) {
            return CacheState.STALE;
        }
        return CacheState.FRESH;
    }

    public AccessToken refreshAccessToken() throws IOException {
        throw new IllegalStateException("OAuth2Credentials instance does not support refreshing the access token. An instance with a new access token should be used, or a derived type that supports refreshing.");
    }

    protected Map<String, List<String>> getAdditionalHeaders() {
        return EMPTY_EXTRA_HEADERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(CredentialsChangedListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayList<CredentialsChangedListener>();
            }
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(CredentialsChangedListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.changeListeners != null) {
                this.changeListeners.remove(listener);
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Nullable
    protected Map<String, List<String>> getRequestMetadataInternal() {
        OAuthValue localValue = this.value;
        if (localValue != null) {
            return localValue.requestMetadata;
        }
        return null;
    }

    public String toString() {
        OAuthValue localValue = this.value;
        Map requestMetadata = null;
        AccessToken temporaryAccess = null;
        if (localValue != null) {
            requestMetadata = localValue.requestMetadata;
            temporaryAccess = localValue.temporaryAccess;
        }
        return MoreObjects.toStringHelper(this).add("requestMetadata", requestMetadata).add("temporaryAccess", temporaryAccess).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2Credentials)) {
            return false;
        }
        OAuth2Credentials other = (OAuth2Credentials)obj;
        return Objects.equals(this.value, other.value);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.clock = Clock.SYSTEM;
        this.refreshTask = null;
    }

    protected static <T> T newInstance(String className) throws IOException, ClassNotFoundException {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    protected static <T> T getFromServiceLoader(Class<? extends T> clazz, T defaultInstance) {
        return Iterables.getFirst(ServiceLoader.load(clazz), defaultInstance);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private AccessToken accessToken;
        private Duration refreshMargin = DEFAULT_REFRESH_MARGIN;
        private Duration expirationMargin = DEFAULT_EXPIRATION_MARGIN;

        protected Builder() {
        }

        protected Builder(OAuth2Credentials credentials) {
            this.accessToken = credentials.getAccessToken();
            this.refreshMargin = credentials.refreshMargin;
            this.expirationMargin = credentials.expirationMargin;
        }

        public Builder setAccessToken(AccessToken token) {
            this.accessToken = token;
            return this;
        }

        public Builder setRefreshMargin(Duration refreshMargin) {
            this.refreshMargin = refreshMargin;
            return this;
        }

        public Duration getRefreshMargin() {
            return this.refreshMargin;
        }

        public Builder setExpirationMargin(Duration expirationMargin) {
            this.expirationMargin = expirationMargin;
            return this;
        }

        public Duration getExpirationMargin() {
            return this.expirationMargin;
        }

        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        public OAuth2Credentials build() {
            return new OAuth2Credentials(this.accessToken, this.refreshMargin, this.expirationMargin);
        }
    }

    class RefreshTask
    extends AbstractFuture<OAuthValue>
    implements Runnable {
        private final ListenableFutureTask<OAuthValue> task;
        private final RefreshTaskListener listener;

        RefreshTask(ListenableFutureTask<OAuthValue> task, RefreshTaskListener listener) {
            this.task = task;
            this.listener = listener;
            task.addListener(listener, MoreExecutors.directExecutor());
            Futures.addCallback(task, new FutureCallback<OAuthValue>(){

                @Override
                public void onSuccess(OAuthValue result) {
                    RefreshTask.this.set(result);
                }

                @Override
                public void onFailure(Throwable t2) {
                    RefreshTask.this.setException(t2);
                }
            }, MoreExecutors.directExecutor());
        }

        public ListenableFutureTask<OAuthValue> getTask() {
            return this.task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    @VisibleForTesting
    class RefreshTaskListener
    implements Runnable {
        private ListenableFutureTask<OAuthValue> task;

        RefreshTaskListener(ListenableFutureTask<OAuthValue> task) {
            this.task = task;
        }

        @Override
        public void run() {
            OAuth2Credentials.this.finishRefreshAsync(this.task);
        }
    }

    static class AsyncRefreshResult {
        private final RefreshTask task;
        private final boolean isNew;

        AsyncRefreshResult(RefreshTask task, boolean isNew) {
            this.task = task;
            this.isNew = isNew;
        }

        void executeIfNew(Executor executor) {
            if (this.isNew) {
                executor.execute(this.task);
            }
        }
    }

    static class FutureCallbackToMetadataCallbackAdapter
    implements FutureCallback<OAuthValue> {
        private final RequestMetadataCallback callback;

        public FutureCallbackToMetadataCallbackAdapter(RequestMetadataCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess(@Nullable OAuthValue value) {
            this.callback.onSuccess(value.requestMetadata);
        }

        @Override
        public void onFailure(Throwable throwable) {
            if (throwable instanceof ExecutionException) {
                throwable = throwable.getCause();
            }
            this.callback.onFailure(throwable);
        }
    }

    static enum CacheState {
        FRESH,
        STALE,
        EXPIRED;

    }

    static class OAuthValue
    implements Serializable {
        private final AccessToken temporaryAccess;
        private final Map<String, List<String>> requestMetadata;

        static OAuthValue create(AccessToken token, Map<String, List<String>> additionalHeaders) {
            return new OAuthValue(token, ImmutableMap.builder().put("Authorization", ImmutableList.of("Bearer " + token.getTokenValue())).putAll(additionalHeaders).build());
        }

        private OAuthValue(AccessToken temporaryAccess, Map<String, List<String>> requestMetadata) {
            this.temporaryAccess = temporaryAccess;
            this.requestMetadata = requestMetadata;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OAuthValue)) {
                return false;
            }
            OAuthValue other = (OAuthValue)obj;
            return Objects.equals(this.requestMetadata, other.requestMetadata) && Objects.equals(this.temporaryAccess, other.temporaryAccess);
        }

        public int hashCode() {
            return Objects.hash(this.temporaryAccess, this.requestMetadata);
        }
    }

    public static interface CredentialsChangedListener {
        public void onChanged(OAuth2Credentials var1) throws IOException;
    }
}

