/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JsonMappingException;
import org.talend.bigdata.jackson.databind.deser.std.StdScalarDeserializer;
import org.talend.bigdata.jackson.databind.type.LogicalType;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (t2 == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean b = this._parseBoolean(p, ctxt, AtomicBoolean.class);
        return b == null ? null : new AtomicBoolean(b);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

