/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava;

import java.io.Serializable;
import java.util.Set;
import org.talend.bigdata.google.common.base.Optional;
import org.talend.bigdata.google.common.cache.Cache;
import org.talend.bigdata.google.common.cache.CacheBuilder;
import org.talend.bigdata.google.common.cache.CacheBuilderSpec;
import org.talend.bigdata.google.common.collect.FluentIterable;
import org.talend.bigdata.google.common.collect.Multimap;
import org.talend.bigdata.google.common.collect.Range;
import org.talend.bigdata.google.common.collect.RangeSet;
import org.talend.bigdata.google.common.collect.Table;
import org.talend.bigdata.google.common.hash.HashCode;
import org.talend.bigdata.google.common.net.HostAndPort;
import org.talend.bigdata.google.common.net.InternetDomainName;
import org.talend.bigdata.jackson.annotation.JsonIgnoreProperties;
import org.talend.bigdata.jackson.databind.AnnotationIntrospector;
import org.talend.bigdata.jackson.databind.BeanDescription;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonSerializer;
import org.talend.bigdata.jackson.databind.MapperFeature;
import org.talend.bigdata.jackson.databind.SerializationConfig;
import org.talend.bigdata.jackson.databind.jsontype.TypeSerializer;
import org.talend.bigdata.jackson.databind.ser.Serializers;
import org.talend.bigdata.jackson.databind.ser.std.StdDelegatingSerializer;
import org.talend.bigdata.jackson.databind.ser.std.ToStringSerializer;
import org.talend.bigdata.jackson.databind.type.MapLikeType;
import org.talend.bigdata.jackson.databind.type.ReferenceType;
import org.talend.bigdata.jackson.databind.util.StdConverter;
import org.talend.bigdata.jackson.datatype.guava.ser.CacheSerializer;
import org.talend.bigdata.jackson.datatype.guava.ser.GuavaOptionalSerializer;
import org.talend.bigdata.jackson.datatype.guava.ser.MultimapSerializer;
import org.talend.bigdata.jackson.datatype.guava.ser.RangeSerializer;
import org.talend.bigdata.jackson.datatype.guava.ser.RangeSetSerializer;
import org.talend.bigdata.jackson.datatype.guava.ser.TableSerializer;

public class GuavaSerializers
extends Serializers.Base
implements Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class<?> raw = refType.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
            return new GuavaOptionalSerializer(refType, staticTyping, contentTypeSerializer, contentValueSerializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (RangeSet.class.isAssignableFrom(raw)) {
            return new RangeSetSerializer();
        }
        if (Range.class.isAssignableFrom(raw)) {
            return new RangeSerializer(this._findDeclared(type, Range.class));
        }
        if (Table.class.isAssignableFrom(raw)) {
            return new TableSerializer(this._findDeclared(type, Table.class));
        }
        if (HostAndPort.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (InternetDomainName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (CacheBuilderSpec.class.isAssignableFrom(raw) || CacheBuilder.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (HashCode.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType iterableType = this._findDeclared(type, Iterable.class);
            return new StdDelegatingSerializer(FluentConverter.instance, iterableType, null);
        }
        if (Cache.class.isAssignableFrom(raw)) {
            return new CacheSerializer();
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (Multimap.class.isAssignableFrom(type.getRawClass())) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            Object filterId = intr.findFilterId(beanDesc.getClassInfo());
            JsonIgnoreProperties.Value ignorals = config.getDefaultPropertyIgnorals(Multimap.class, beanDesc.getClassInfo());
            Set<String> ignored = ignorals == null ? null : ignorals.getIgnored();
            return new MultimapSerializer(type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer, ignored, filterId);
        }
        return null;
    }

    private JavaType _findDeclared(JavaType subtype, Class<?> target) {
        JavaType decl = subtype.findSuperType(target);
        if (decl == null) {
            throw new IllegalArgumentException("Strange " + target.getName() + " sub-type, " + subtype + ", can not find type parameters");
        }
        return decl;
    }

    static class FluentConverter
    extends StdConverter<Object, Iterable<?>> {
        static final FluentConverter instance = new FluentConverter();

        FluentConverter() {
        }

        @Override
        public Iterable<?> convert(Object value) {
            return (Iterable)value;
        }
    }
}

