/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava.deser;

import java.io.IOException;
import org.talend.bigdata.google.common.collect.ImmutableCollection;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.databind.DeserializationConfig;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.deser.NullValueProvider;
import org.talend.bigdata.jackson.databind.jsontype.TypeDeserializer;
import org.talend.bigdata.jackson.databind.util.AccessPattern;
import org.talend.bigdata.jackson.datatype.guava.deser.GuavaCollectionDeserializer;

abstract class GuavaImmutableCollectionDeserializer<T extends ImmutableCollection<Object>>
extends GuavaCollectionDeserializer<T> {
    private static final long serialVersionUID = 1L;

    GuavaImmutableCollectionDeserializer(JavaType selfType, JsonDeserializer<?> deser, TypeDeserializer typeDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    protected abstract ImmutableCollection.Builder<Object> createBuilder();

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public T getEmptyValue(DeserializationContext ctxt) {
        return (T)((ImmutableCollection)this._createEmpty(ctxt));
    }

    @Override
    protected T _deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        ImmutableCollection.Builder<Object> builder = this.createBuilder();
        while ((t2 = p.nextToken()) != JsonToken.END_ARRAY) {
            Object value;
            if (t2 == JsonToken.VALUE_NULL) {
                if (this._skipNullValues) continue;
                value = this._resolveNullToValue(ctxt);
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
            }
            builder.add(value);
        }
        ImmutableCollection<Object> collection = builder.build();
        return (T)collection;
    }

    protected Object _resolveNullToValue(DeserializationContext ctxt) throws IOException {
        Object value = this._nullProvider.getNullValue(ctxt);
        return value;
    }
}

