/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava.deser;

import java.io.IOException;
import org.talend.bigdata.google.common.collect.ImmutableMap;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.KeyDeserializer;
import org.talend.bigdata.jackson.databind.deser.NullValueProvider;
import org.talend.bigdata.jackson.databind.jsontype.TypeDeserializer;
import org.talend.bigdata.jackson.databind.util.AccessPattern;
import org.talend.bigdata.jackson.datatype.guava.deser.GuavaMapDeserializer;

abstract class GuavaImmutableMapDeserializer<T extends ImmutableMap<Object, Object>>
extends GuavaMapDeserializer<T> {
    private static final long serialVersionUID = 2L;

    GuavaImmutableMapDeserializer(JavaType type, KeyDeserializer keyDeser, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser, NullValueProvider nuller) {
        super(type, keyDeser, valueDeser, valueTypeDeser, nuller);
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    protected abstract ImmutableMap.Builder<Object, Object> createBuilder();

    @Override
    protected T _deserializeEntries(JsonParser p, DeserializationContext ctxt) throws IOException {
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        ImmutableMap.Builder<Object, Object> builder = this.createBuilder();
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            Object value;
            String fieldName = p.getCurrentName();
            String key = keyDes == null ? fieldName : keyDes.deserializeKey(fieldName, ctxt);
            JsonToken t2 = p.nextToken();
            if (t2 == JsonToken.VALUE_NULL) {
                if (!this._skipNullValues && (value = this._nullProvider.getNullValue(ctxt)) != null) {
                    builder.put(key, value);
                }
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
                builder.put(key, value);
            }
            p.nextToken();
        }
        ImmutableMap<Object, Object> map = builder.build();
        return (T)map;
    }
}

