/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.talend.bigdata.jackson.core.JsonProcessingException;
import org.talend.bigdata.jackson.core.TreeNode;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ArrayNode;

class BodyLogger {
    private final Set<String> redactKeys = new HashSet<String>(){
        {
            this.add("string_value");
            this.add("token_value");
            this.add("content");
        }
    };
    private int maxBytes = 1023;
    private int debugTruncateBytes = 96;
    private final ObjectMapper mapper;

    public BodyLogger(ObjectMapper mapper, int maxBytes, int debugTruncateBytes) {
        this.mapper = mapper;
        if (maxBytes == 0) {
            maxBytes = 1024;
        }
        if (debugTruncateBytes > maxBytes) {
            maxBytes = debugTruncateBytes;
        }
        this.maxBytes = maxBytes;
        this.debugTruncateBytes = debugTruncateBytes;
    }

    private List<String> mapKeys(TreeNode node) {
        ArrayList<String> keys = new ArrayList<String>();
        node.fieldNames().forEachRemaining(keys::add);
        Collections.sort(keys);
        return keys;
    }

    public String redactedDump(String body) {
        if (body == null || body.isEmpty()) {
            return "";
        }
        try {
            JsonNode rootNode = this.mapper.readTree(body);
            Object result = this.recursiveMarshal(rootNode, this.maxBytes);
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            return BodyLogger.onlyNBytes(body, this.maxBytes);
        }
    }

    private Object recursiveMarshal(JsonNode node, int budget) {
        if (node.isObject()) {
            return this.recursiveMarshalObject(node, budget);
        }
        if (node.isArray()) {
            return this.recursiveMarshalArray((ArrayNode)node, budget);
        }
        if (node.isTextual()) {
            return BodyLogger.onlyNBytes(node.asText(), this.debugTruncateBytes);
        }
        if (node.isNumber()) {
            return node.asLong();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asToken().asString();
    }

    private List<Object> recursiveMarshalArray(ArrayNode rawArray, int budget) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (int i = 0; i < rawArray.size(); ++i) {
            if (i > 0 && budget <= 0) {
                out.add(String.format("... (%d additional elements)", rawArray.size() - out.size()));
                break;
            }
            Object raw = this.recursiveMarshal(rawArray.get(i), budget);
            out.add(raw);
            budget -= raw.toString().length();
        }
        return out;
    }

    private Map<String, Object> recursiveMarshalObject(JsonNode node, int budget) {
        TreeMap<String, Object> out = new TreeMap<String, Object>();
        for (String key : this.mapKeys(node)) {
            if (this.redactKeys.contains(key)) {
                out.put(key, "**REDACTED**");
                continue;
            }
            JsonNode valueNode = node.get(key);
            Object result = this.recursiveMarshal(valueNode, budget);
            budget -= result.toString().length();
            out.put(key, result);
        }
        return out;
    }

    private static String onlyNBytes(String j, int numBytes) {
        int diff = j.getBytes().length - numBytes;
        if (diff > 0) {
            return String.format("%s... (%d more bytes)", j.substring(0, numBytes), diff);
        }
        return j;
    }
}

