/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.error;

import com.databricks.sdk.core.DatabricksError;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.error.ApiErrorBody;
import com.databricks.sdk.core.error.ErrorMapper;
import com.databricks.sdk.core.error.PrivateLinkInfo;
import com.databricks.sdk.core.error.details.ErrorDetails;
import com.databricks.sdk.core.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.talend.bigdata.google.api.client.util.Strings;
import org.talend.bigdata.io.IOUtils;
import org.talend.bigdata.jackson.databind.ObjectMapper;

public class ApiErrors {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Pattern HTML_ERROR_REGEX = Pattern.compile("<pre>(.*)</pre>");
    private static final ErrorMapper ERROR_MAPPER = new ErrorMapper();
    private static final String SCIM_NULL_DETAILS = "null";
    private static final ErrorDetails DEFAULT_ERROR_DETAILS = ErrorDetails.builder().build();

    public static DatabricksError getDatabricksError(Response response) {
        if (PrivateLinkInfo.isPrivateLinkRedirect(response)) {
            return ERROR_MAPPER.apply(response, new ApiErrorBody());
        }
        Optional<ApiErrorBody> optionalErrorBody = ApiErrors.parseApiError(response);
        if (!optionalErrorBody.isPresent()) {
            return ERROR_MAPPER.apply(response, new ApiErrorBody());
        }
        ApiErrorBody errorBody = optionalErrorBody.get();
        ApiErrors.normalizeError(errorBody);
        return ERROR_MAPPER.apply(response, errorBody);
    }

    private static void normalizeError(ApiErrorBody errorBody) {
        if (errorBody.getErrorDetails() == null) {
            errorBody.setErrorDetails(DEFAULT_ERROR_DETAILS);
        }
        if (!Strings.isNullOrEmpty((String)errorBody.getApi12Error())) {
            errorBody.setMessage(errorBody.getApi12Error());
            return;
        }
        if (!Strings.isNullOrEmpty((String)errorBody.getMessage())) {
            return;
        }
        if (Strings.isNullOrEmpty((String)errorBody.getScimDetail())) {
            return;
        }
        if (SCIM_NULL_DETAILS.equals(errorBody.getScimDetail())) {
            errorBody.setMessage("SCIM API Internal Error");
        } else {
            errorBody.setMessage(errorBody.getScimDetail());
        }
        if (!Strings.isNullOrEmpty((String)errorBody.getScimType())) {
            String message = errorBody.getScimType() + " " + errorBody.getMessage();
            errorBody.setMessage(message.trim());
        }
        if (!Strings.isNullOrEmpty((String)errorBody.getScimStatus())) {
            errorBody.setErrorCode("SCIM_" + errorBody.getScimStatus());
        }
    }

    private static Optional<ApiErrorBody> parseApiError(Response response) {
        String body;
        InputStream in = response.getBody();
        if (in == null) {
            return Optional.empty();
        }
        try {
            body = IOUtils.toString(in, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to read response body", e);
        }
        if (Strings.isNullOrEmpty((String)body)) {
            return Optional.empty();
        }
        try {
            return Optional.of(MAPPER.readValue(body, ApiErrorBody.class));
        }
        catch (IOException e) {
            return Optional.of(ApiErrors.parseUnknownError(response, body, e));
        }
    }

    private static ApiErrorBody parseUnknownError(Response response, String body, IOException err) {
        ApiErrorBody errorBody = new ApiErrorBody();
        String[] statusParts = response.getStatus().split(" ", 2);
        if (statusParts.length < 2) {
            errorBody.setErrorCode("UNKNOWN");
        } else {
            String errorCode = statusParts[1].replaceAll("^[ .]+|[ .]+$", "");
            errorBody.setErrorCode(errorCode.replaceAll(" ", "_").toUpperCase());
        }
        Matcher messageMatcher = HTML_ERROR_REGEX.matcher(body);
        if (messageMatcher.find()) {
            errorBody.setMessage(messageMatcher.group(1).replaceAll("^[ .]+|[ .]+$", ""));
        } else {
            errorBody.setMessage(String.format("Response from server (%s) %s: %s", response.getStatus(), body, err.getMessage()));
        }
        return errorBody;
    }
}

