/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.oauth.IDToken;
import com.databricks.sdk.core.oauth.IDTokenSource;
import com.databricks.sdk.core.utils.Environment;
import org.talend.bigdata.google.common.base.Strings;

public class EnvVarIDTokenSource
implements IDTokenSource {
    private final String envVarName;
    private final Environment env;

    public EnvVarIDTokenSource(String envVarName, Environment env) {
        this.envVarName = envVarName;
        this.env = env;
    }

    @Override
    public IDToken getIDToken(String audience) {
        if (Strings.isNullOrEmpty(this.envVarName)) {
            throw new IllegalArgumentException("Environment variable name cannot be null or empty");
        }
        try {
            String token = this.env.get(this.envVarName);
            return new IDToken(token);
        }
        catch (IllegalArgumentException e) {
            throw new DatabricksException(String.format("Received empty ID token from environment variable %s", this.envVarName), e);
        }
    }
}

