/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenSource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public interface OAuthHeaderFactory
extends HeaderFactory,
TokenSource {
    public static OAuthHeaderFactory fromSuppliers(final Supplier<Token> tokenSupplier, final Supplier<Map<String, String>> headerSupplier) {
        return new OAuthHeaderFactory(){

            @Override
            public Map<String, String> headers() {
                return (Map)headerSupplier.get();
            }

            @Override
            public Token getToken() {
                return (Token)tokenSupplier.get();
            }
        };
    }

    public static OAuthHeaderFactory fromTokenSource(final TokenSource tokenSource) {
        return new OAuthHeaderFactory(){

            @Override
            public Token getToken() {
                return tokenSource.getToken();
            }

            @Override
            public Map<String, String> headers() {
                Token token = tokenSource.getToken();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
                return headers;
            }
        };
    }
}

