/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import java.time.Instant;
import java.util.Objects;
import org.talend.bigdata.jackson.annotation.JsonCreator;
import org.talend.bigdata.jackson.annotation.JsonProperty;

public class Token {
    @JsonProperty
    private String accessToken;
    @JsonProperty
    private String tokenType;
    @JsonProperty
    private String refreshToken;
    @JsonProperty
    private Instant expiry;

    public Token(String accessToken, String tokenType, Instant expiry) {
        this(accessToken, tokenType, null, expiry);
    }

    @JsonCreator
    public Token(@JsonProperty(value="accessToken") String accessToken, @JsonProperty(value="tokenType") String tokenType, @JsonProperty(value="refreshToken") String refreshToken, @JsonProperty(value="expiry") Instant expiry) {
        Objects.requireNonNull(accessToken, "accessToken must be defined");
        Objects.requireNonNull(tokenType, "tokenType must be defined");
        Objects.requireNonNull(expiry, "expiry must be defined");
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.expiry = expiry;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Instant getExpiry() {
        return this.expiry;
    }
}

