/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateRegisteredModelRequest;
import com.databricks.sdk.service.catalog.DeleteAliasRequest;
import com.databricks.sdk.service.catalog.DeleteRegisteredModelRequest;
import com.databricks.sdk.service.catalog.GetRegisteredModelRequest;
import com.databricks.sdk.service.catalog.ListRegisteredModelsRequest;
import com.databricks.sdk.service.catalog.ListRegisteredModelsResponse;
import com.databricks.sdk.service.catalog.RegisteredModelAlias;
import com.databricks.sdk.service.catalog.RegisteredModelInfo;
import com.databricks.sdk.service.catalog.RegisteredModelsService;
import com.databricks.sdk.service.catalog.SetRegisteredModelAliasRequest;
import com.databricks.sdk.service.catalog.UpdateRegisteredModelRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class RegisteredModelsImpl
implements RegisteredModelsService {
    private final ApiClient apiClient;

    public RegisteredModelsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RegisteredModelInfo create(CreateRegisteredModelRequest request) {
        String path = "/api/2.1/unity-catalog/models";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegisteredModelInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAlias(DeleteAliasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/aliases/%s", request.getFullName(), request.getAlias());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelInfo get(GetRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, RegisteredModelInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRegisteredModelsResponse list(ListRegisteredModelsRequest request) {
        String path = "/api/2.1/unity-catalog/models";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRegisteredModelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelAlias setAlias(SetRegisteredModelAliasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/aliases/%s", request.getFullName(), request.getAlias());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegisteredModelAlias.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RegisteredModelInfo update(UpdateRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RegisteredModelInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

