/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settingsv2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settingsv2.AccountSettingsV2Impl;
import com.databricks.sdk.service.settingsv2.AccountSettingsV2Service;
import com.databricks.sdk.service.settingsv2.GetPublicAccountSettingRequest;
import com.databricks.sdk.service.settingsv2.ListAccountSettingsMetadataRequest;
import com.databricks.sdk.service.settingsv2.ListAccountSettingsMetadataResponse;
import com.databricks.sdk.service.settingsv2.PatchPublicAccountSettingRequest;
import com.databricks.sdk.service.settingsv2.Setting;
import com.databricks.sdk.service.settingsv2.SettingsMetadata;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountSettingsV2API {
    private static final Logger LOG = LoggerFactory.getLogger(AccountSettingsV2API.class);
    private final AccountSettingsV2Service impl;

    public AccountSettingsV2API(ApiClient apiClient) {
        this.impl = new AccountSettingsV2Impl(apiClient);
    }

    public AccountSettingsV2API(AccountSettingsV2Service mock) {
        this.impl = mock;
    }

    public Setting getPublicAccountSetting(String name) {
        return this.getPublicAccountSetting(new GetPublicAccountSettingRequest().setName(name));
    }

    public Setting getPublicAccountSetting(GetPublicAccountSettingRequest request) {
        return this.impl.getPublicAccountSetting(request);
    }

    public Iterable<SettingsMetadata> listAccountSettingsMetadata(ListAccountSettingsMetadataRequest request) {
        return new Paginator(request, this.impl::listAccountSettingsMetadata, ListAccountSettingsMetadataResponse::getSettingsMetadata, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Setting patchPublicAccountSetting(PatchPublicAccountSettingRequest request) {
        return this.impl.patchPublicAccountSetting(request);
    }

    public AccountSettingsV2Service impl() {
        return this.impl;
    }
}

