/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import org.talend.bigdata.google.api.client.http.HttpResponseException;
import org.talend.bigdata.google.api.client.json.GenericJson;
import org.talend.bigdata.google.api.client.json.JsonParser;
import org.talend.bigdata.google.auth.oauth2.GoogleAuthException;
import org.talend.bigdata.google.auth.oauth2.OAuth2Utils;
import org.talend.bigdata.google.common.base.Preconditions;
import org.talend.bigdata.javax.annotation.Nullable;

class OAuthException
extends GoogleAuthException {
    private final String errorCode;
    @Nullable
    private final String errorDescription;
    @Nullable
    private final String errorUri;

    OAuthException(String errorCode, @Nullable String errorDescription, @Nullable String errorUri) {
        this.errorCode = Preconditions.checkNotNull(errorCode);
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Error code " + this.errorCode);
        if (this.errorDescription != null) {
            sb.append(": ").append(this.errorDescription);
        }
        if (this.errorUri != null) {
            sb.append(" - ").append(this.errorUri);
        }
        return sb.toString();
    }

    String getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    String getErrorUri() {
        return this.errorUri;
    }

    static OAuthException createFromHttpResponseException(HttpResponseException e) throws IOException {
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(e.getContent());
        GenericJson errorResponse = (GenericJson)parser.parseAndClose(GenericJson.class);
        String errorCode = (String)errorResponse.get((Object)"error");
        String errorDescription = null;
        String errorUri = null;
        if (errorResponse.containsKey((Object)"error_description")) {
            errorDescription = (String)errorResponse.get((Object)"error_description");
        }
        if (errorResponse.containsKey((Object)"error_uri")) {
            errorUri = (String)errorResponse.get((Object)"error_uri");
        }
        return new OAuthException(errorCode, errorDescription, errorUri);
    }
}

