/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.talend.bigdata.google.api.client.http.GenericUrl;
import org.talend.bigdata.google.api.client.http.HttpContent;
import org.talend.bigdata.google.api.client.http.HttpHeaders;
import org.talend.bigdata.google.api.client.http.HttpRequest;
import org.talend.bigdata.google.api.client.http.HttpRequestFactory;
import org.talend.bigdata.google.api.client.http.HttpResponse;
import org.talend.bigdata.google.api.client.http.HttpResponseException;
import org.talend.bigdata.google.api.client.http.UrlEncodedContent;
import org.talend.bigdata.google.api.client.json.GenericJson;
import org.talend.bigdata.google.api.client.json.JsonObjectParser;
import org.talend.bigdata.google.api.client.json.JsonParser;
import org.talend.bigdata.google.api.client.util.GenericData;
import org.talend.bigdata.google.api.client.util.ObjectParser;
import org.talend.bigdata.google.auth.oauth2.OAuth2Utils;
import org.talend.bigdata.google.auth.oauth2.OAuthException;
import org.talend.bigdata.google.auth.oauth2.StsTokenExchangeRequest;
import org.talend.bigdata.google.auth.oauth2.StsTokenExchangeResponse;
import org.talend.bigdata.google.common.base.Joiner;
import org.talend.bigdata.javax.annotation.Nullable;

final class StsRequestHandler {
    private static final String TOKEN_EXCHANGE_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token response.";
    private final String tokenExchangeEndpoint;
    private final StsTokenExchangeRequest request;
    private final HttpRequestFactory httpRequestFactory;
    @Nullable
    private final HttpHeaders headers;
    @Nullable
    private final String internalOptions;

    private StsRequestHandler(String tokenExchangeEndpoint, StsTokenExchangeRequest request, HttpRequestFactory httpRequestFactory, @Nullable HttpHeaders headers, @Nullable String internalOptions) {
        this.tokenExchangeEndpoint = tokenExchangeEndpoint;
        this.request = request;
        this.httpRequestFactory = httpRequestFactory;
        this.headers = headers;
        this.internalOptions = internalOptions;
    }

    public static Builder newBuilder(String tokenExchangeEndpoint, StsTokenExchangeRequest stsTokenExchangeRequest, HttpRequestFactory httpRequestFactory) {
        return new Builder(tokenExchangeEndpoint, stsTokenExchangeRequest, httpRequestFactory);
    }

    public StsTokenExchangeResponse exchangeToken() throws IOException {
        UrlEncodedContent content = new UrlEncodedContent((Object)this.buildTokenRequest());
        HttpRequest httpRequest = this.httpRequestFactory.buildPostRequest(new GenericUrl(this.tokenExchangeEndpoint), (HttpContent)content);
        httpRequest.setParser((ObjectParser)new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.headers != null) {
            httpRequest.setHeaders(this.headers);
        }
        try {
            HttpResponse response = httpRequest.execute();
            GenericData responseData = (GenericData)response.parseAs(GenericData.class);
            return this.buildResponse(responseData);
        }
        catch (HttpResponseException e) {
            throw OAuthException.createFromHttpResponseException(e);
        }
    }

    private GenericData buildTokenRequest() {
        GenericData tokenRequest = new GenericData().set("grant_type", (Object)TOKEN_EXCHANGE_GRANT_TYPE).set("subject_token_type", (Object)this.request.getSubjectTokenType()).set("subject_token", (Object)this.request.getSubjectToken());
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.request.hasScopes()) {
            scopes.addAll(this.request.getScopes());
            tokenRequest.set("scope", (Object)Joiner.on(' ').join(scopes));
        }
        String requestTokenType = this.request.hasRequestedTokenType() ? this.request.getRequestedTokenType() : "urn:ietf:params:oauth:token-type:access_token";
        tokenRequest.set("requested_token_type", (Object)requestTokenType);
        if (this.request.hasResource()) {
            tokenRequest.set("resource", (Object)this.request.getResource());
        }
        if (this.request.hasAudience()) {
            tokenRequest.set("audience", (Object)this.request.getAudience());
        }
        if (this.request.hasActingParty()) {
            tokenRequest.set("actor_token", (Object)this.request.getActingParty().getActorToken());
            tokenRequest.set("actor_token_type", (Object)this.request.getActingParty().getActorTokenType());
        }
        if (this.internalOptions != null && !this.internalOptions.isEmpty()) {
            tokenRequest.set("options", (Object)this.internalOptions);
        }
        return tokenRequest;
    }

    private StsTokenExchangeResponse buildResponse(GenericData responseData) throws IOException {
        String accessToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "access_token", PARSE_ERROR_PREFIX);
        String issuedTokenType = OAuth2Utils.validateString((Map<String, Object>)responseData, "issued_token_type", PARSE_ERROR_PREFIX);
        String tokenType = OAuth2Utils.validateString((Map<String, Object>)responseData, "token_type", PARSE_ERROR_PREFIX);
        StsTokenExchangeResponse.Builder builder = StsTokenExchangeResponse.newBuilder(accessToken, issuedTokenType, tokenType);
        if (responseData.containsKey((Object)"expires_in")) {
            builder.setExpiresInSeconds(OAuth2Utils.validateLong((Map<String, Object>)responseData, "expires_in", PARSE_ERROR_PREFIX));
        }
        if (responseData.containsKey((Object)"refresh_token")) {
            builder.setRefreshToken(OAuth2Utils.validateString((Map<String, Object>)responseData, "refresh_token", PARSE_ERROR_PREFIX));
        }
        if (responseData.containsKey((Object)"scope")) {
            String scope = OAuth2Utils.validateString((Map<String, Object>)responseData, "scope", PARSE_ERROR_PREFIX);
            builder.setScopes(Arrays.asList(scope.trim().split("\\s+")));
        }
        return builder.build();
    }

    private GenericJson parseJson(String json) throws IOException {
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(json);
        return (GenericJson)parser.parseAndClose(GenericJson.class);
    }

    public static class Builder {
        private final String tokenExchangeEndpoint;
        private final StsTokenExchangeRequest request;
        private final HttpRequestFactory httpRequestFactory;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private String internalOptions;

        private Builder(String tokenExchangeEndpoint, StsTokenExchangeRequest stsTokenExchangeRequest, HttpRequestFactory httpRequestFactory) {
            this.tokenExchangeEndpoint = tokenExchangeEndpoint;
            this.request = stsTokenExchangeRequest;
            this.httpRequestFactory = httpRequestFactory;
        }

        public Builder setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder setInternalOptions(String internalOptions) {
            this.internalOptions = internalOptions;
            return this;
        }

        public StsRequestHandler build() {
            return new StsRequestHandler(this.tokenExchangeEndpoint, this.request, this.httpRequestFactory, this.headers, this.internalOptions);
        }
    }
}

