/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.common.base;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.talend.bigdata.google.common.annotations.GwtCompatible;
import org.talend.bigdata.google.common.base.Absent;
import org.talend.bigdata.google.common.base.AbstractIterator;
import org.talend.bigdata.google.common.base.ElementTypesAreNonnullByDefault;
import org.talend.bigdata.google.common.base.Function;
import org.talend.bigdata.google.common.base.Preconditions;
import org.talend.bigdata.google.common.base.Present;
import org.talend.bigdata.google.common.base.Supplier;
import org.talend.bigdata.google.errorprone.annotations.DoNotMock;
import org.talend.bigdata.javax.annotation.CheckForNull;

@DoNotMock(value="Use Optional.of(value) or Optional.absent()")
@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@CheckForNull T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T or(Supplier<? extends T> var1);

    @CheckForNull
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(@CheckForNull Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> optionals) {
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    @CheckForNull
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

