/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.common.collect;

import java.util.Map;
import org.talend.bigdata.google.common.annotations.GwtIncompatible;
import org.talend.bigdata.google.common.collect.ElementTypesAreNonnullByDefault;
import org.talend.bigdata.google.common.collect.Range;
import org.talend.bigdata.google.errorprone.annotations.DoNotMock;
import org.talend.bigdata.javax.annotation.CheckForNull;

@DoNotMock(value="Use ImmutableRangeMap or TreeRangeMap")
@ElementTypesAreNonnullByDefault
@GwtIncompatible
public interface RangeMap<K extends Comparable, V> {
    @CheckForNull
    public V get(K var1);

    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K var1);

    public Range<K> span();

    public void put(Range<K> var1, V var2);

    public void putCoalescing(Range<K> var1, V var2);

    public void putAll(RangeMap<K, ? extends V> var1);

    public void clear();

    public void remove(Range<K> var1);

    public Map<Range<K>, V> asMapOfRanges();

    public Map<Range<K>, V> asDescendingMapOfRanges();

    public RangeMap<K, V> subRangeMap(Range<K> var1);

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();

    public String toString();
}

