/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.io;

import org.talend.bigdata.http.HttpRequest;
import org.talend.bigdata.http.HttpRequestFactory;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.config.MessageConstraints;
import org.talend.bigdata.http.impl.DefaultHttpRequestFactory;
import org.talend.bigdata.http.impl.io.DefaultHttpRequestParser;
import org.talend.bigdata.http.io.HttpMessageParser;
import org.talend.bigdata.http.io.HttpMessageParserFactory;
import org.talend.bigdata.http.io.SessionInputBuffer;
import org.talend.bigdata.http.message.BasicLineParser;
import org.talend.bigdata.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

