/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.datatype.guava.deser;

import java.io.IOException;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.databind.BeanProperty;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.JsonMappingException;
import org.talend.bigdata.jackson.databind.KeyDeserializer;
import org.talend.bigdata.jackson.databind.deser.ContextualDeserializer;
import org.talend.bigdata.jackson.databind.deser.ContextualKeyDeserializer;
import org.talend.bigdata.jackson.databind.deser.NullValueProvider;
import org.talend.bigdata.jackson.databind.deser.std.ContainerDeserializerBase;
import org.talend.bigdata.jackson.databind.jsontype.TypeDeserializer;
import org.talend.bigdata.jackson.databind.type.LogicalType;
import org.talend.bigdata.jackson.databind.util.AccessPattern;

public abstract class GuavaMapDeserializer<T>
extends ContainerDeserializerBase<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    protected GuavaMapDeserializer(JavaType type, KeyDeserializer keyDeser, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser, NullValueProvider nuller) {
        super(type, nuller, null);
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public abstract GuavaMapDeserializer<T> withResolved(KeyDeserializer var1, JsonDeserializer<?> var2, TypeDeserializer var3, NullValueProvider var4);

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer keyDeser = this._keyDeserializer;
        JsonDeserializer<Object> valueDeser = this._valueDeserializer;
        valueDeser = this.findConvertingContentDeserializer(ctxt, property, valueDeser);
        TypeDeserializer valueTypeDeser = this._valueTypeDeserializer;
        if (keyDeser == null) {
            keyDeser = ctxt.findKeyDeserializer(this._containerType.getKeyType(), property);
        } else if (keyDeser instanceof ContextualKeyDeserializer) {
            keyDeser = ((ContextualKeyDeserializer)((Object)keyDeser)).createContextual(ctxt, property);
        }
        JavaType vt = this._containerType.getContentType();
        valueDeser = valueDeser == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(valueDeser, property, vt);
        if (valueTypeDeser != null) {
            valueTypeDeser = valueTypeDeser.forProperty(property);
        }
        NullValueProvider nuller = this.findContentNullProvider(ctxt, property, valueDeser);
        if (this._keyDeserializer == keyDeser && this._valueDeserializer == valueDeser && this._valueTypeDeserializer == valueTypeDeser && this._nullProvider == nuller) {
            return this;
        }
        return this.withResolved(keyDeser, valueDeser, valueTypeDeser, nuller);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        }
        if (t2 != JsonToken.FIELD_NAME && t2 != JsonToken.END_OBJECT) {
            return (T)ctxt.handleUnexpectedToken(this._containerType.getRawClass(), p);
        }
        return this._deserializeEntries(p, ctxt);
    }

    @Override
    public abstract AccessPattern getEmptyAccessPattern();

    @Override
    public abstract Object getEmptyValue(DeserializationContext var1) throws JsonMappingException;

    protected abstract T _deserializeEntries(JsonParser var1, DeserializationContext var2) throws IOException;
}

