/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.service.compute.ClusterPoliciesAPI;
import com.databricks.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.sdk.service.compute.Policy;

public class DatabricksPoliciesClient {
    private final WorkspaceClient w;
    private final ClusterPoliciesAPI clusterPoliciesAPI;

    public DatabricksPoliciesClient(String endpoint, String token) {
        DatabricksConfig config = new DatabricksConfig().setHost(endpoint).setToken(token);
        this.w = new WorkspaceClient(config);
        this.clusterPoliciesAPI = this.w.clusterPolicies();
    }

    public DatabricksPoliciesClient(String endpoint, String secretID, String clientID) {
        DatabricksConfig config = new DatabricksConfig().setHost(endpoint).setClientId(clientID).setClientSecret(secretID);
        this.w = new WorkspaceClient(config);
        this.clusterPoliciesAPI = this.w.clusterPolicies();
    }

    public Iterable<Policy> list() {
        return this.clusterPoliciesAPI.list(new ListClusterPoliciesRequest());
    }

    public String getPolicyId(String policyName) {
        Iterable<Policy> policies = this.list();
        for (Policy policy : policies) {
            if (policyName == null || !policyName.equals(policy.getName())) continue;
            return policy.getPolicyId();
        }
        return "POLICY_NOT_FOUND(" + policyName + ")";
    }
}

