/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import com.databricks.sdk.service.compute.ClusterLogConf;
import com.databricks.sdk.service.compute.DbfsStorageInfo;
import com.databricks.sdk.service.compute.InitScriptInfo;
import com.databricks.sdk.service.compute.S3StorageInfo;
import com.databricks.sdk.service.compute.VolumesStorageInfo;
import com.databricks.sdk.service.compute.WorkspaceStorageInfo;
import org.talend.bigdata.launcher.databricks.DatabricksStorageDestinationS3;

public class DatabricksStorageInfo {
    private DatabricksStorageTypeEnum type;
    private String destination;
    private DatabricksStorageDestinationS3 s3;

    public DatabricksStorageInfo(String destination, DatabricksStorageTypeEnum type) {
        this.destination = destination;
        this.type = type;
    }

    public DatabricksStorageInfo(DatabricksStorageDestinationS3 s3Destination) {
        this.type = DatabricksStorageTypeEnum.S3;
        this.s3 = s3Destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public DatabricksStorageDestinationS3 getS3() {
        return this.s3;
    }

    public DatabricksStorageTypeEnum getType() {
        return this.type;
    }

    public InitScriptInfo toInitScriptInfo() {
        switch (this.type) {
            case DBFS: {
                return new InitScriptInfo().setDbfs(new DbfsStorageInfo().setDestination(this.destination));
            }
            case WORKSPACE: {
                return new InitScriptInfo().setWorkspace(new WorkspaceStorageInfo().setDestination(this.destination));
            }
            case S3: {
                if (this.s3 == null) {
                    throw new IllegalStateException("S3 destination details required");
                }
                return new InitScriptInfo().setS3(new S3StorageInfo().setDestination(this.s3.getDestination()).setCannedAcl(this.s3.getCannedAcl()).setEnableEncryption(this.s3.getEnableEncryption()).setEncryptionType(this.s3.getEncryptionType()).setKmsKey(this.s3.getKmsKey()).setRegion(this.s3.getRegion()));
            }
        }
        throw new IllegalStateException("Unsupported storage type: " + (Object)((Object)this.type));
    }

    public ClusterLogConf toClusterLogConf() {
        switch (this.type) {
            case DBFS: {
                return new ClusterLogConf().setDbfs(new DbfsStorageInfo().setDestination(this.destination));
            }
            case WORKSPACE: {
                return new ClusterLogConf().setVolumes(new VolumesStorageInfo().setDestination(this.destination));
            }
            case S3: {
                if (this.s3 == null) {
                    throw new IllegalStateException("S3 destination details required");
                }
                return new ClusterLogConf().setS3(new S3StorageInfo().setDestination(this.s3.getDestination()).setCannedAcl(this.s3.getCannedAcl()).setEnableEncryption(this.s3.getEnableEncryption()).setEncryptionType(this.s3.getEncryptionType()).setKmsKey(this.s3.getKmsKey()).setRegion(this.s3.getRegion()));
            }
        }
        throw new IllegalStateException("Unsupported storage type: " + (Object)((Object)this.type));
    }

    public static enum DatabricksStorageTypeEnum {
        WORKSPACE,
        S3,
        DBFS;

    }
}

