/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks.filesystem;

import com.databricks.sdk.WorkspaceClient;
import com.databricks.sdk.service.files.AddBlock;
import com.databricks.sdk.service.files.Create;
import com.databricks.sdk.service.files.CreateResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.codec.binary.Base64;

public class DatabricksFileSystemUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksFileSystemUtil.class);
    protected static final int API_MAX_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromLocal(WorkspaceClient workspace, String localFile, String remoteFile, boolean overwrite) {
        Long handle = null;
        File uploadFile = new File(localFile.trim());
        try {
            CreateResponse create = workspace.dbfs().create(new Create().setPath(remoteFile).setOverwrite(overwrite));
            handle = create.getHandle();
            int fileLength = (int)uploadFile.length();
            int bufferSize = Math.min(0x100000, fileLength);
            byte[] buffer = new byte[bufferSize];
            Base64 encoder = new Base64();
            try (FileInputStream fis = new FileInputStream(uploadFile);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                int bytesRead;
                while ((bytesRead = bis.read(buffer)) > 0) {
                    byte[] actualBuffer = buffer;
                    if (bytesRead < bufferSize) {
                        actualBuffer = new byte[bytesRead];
                        System.arraycopy(buffer, 0, actualBuffer, 0, bytesRead);
                    }
                    byte[] encodedBytes = encoder.encode(actualBuffer);
                    workspace.dbfs().addBlock(new AddBlock().setHandle(handle).setData(new String(encodedBytes)));
                }
                LOG.info("Uploaded {} to DBFS: {}", (Object)localFile, (Object)remoteFile);
            }
            catch (Exception e) {
                LOG.error("error uploading {} : {}", (Object)remoteFile, (Object)e);
            }
        }
        finally {
            if (handle != null) {
                workspace.dbfs().close(handle);
            }
        }
    }
}

