/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.error.details;

import com.databricks.sdk.core.error.details.BadRequest;
import com.databricks.sdk.core.error.details.DebugInfo;
import com.databricks.sdk.core.error.details.ErrorDetails;
import com.databricks.sdk.core.error.details.ErrorInfo;
import com.databricks.sdk.core.error.details.Help;
import com.databricks.sdk.core.error.details.PreconditionFailure;
import com.databricks.sdk.core.error.details.QuotaFailure;
import com.databricks.sdk.core.error.details.RequestInfo;
import com.databricks.sdk.core.error.details.ResourceInfo;
import com.databricks.sdk.core.error.details.RetryInfo;
import java.io.IOException;
import java.util.ArrayList;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.core.TreeNode;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ArrayNode;
import org.talend.bigdata.jackson.databind.node.ObjectNode;

public class ErrorDetailsDeserializer
extends JsonDeserializer<ErrorDetails> {
    private static final String ERROR_INFO_TYPE = "type.googleapis.com/google.rpc.ErrorInfo";
    private static final String REQUEST_INFO_TYPE = "type.googleapis.com/google.rpc.RequestInfo";
    private static final String RETRY_INFO_TYPE = "type.googleapis.com/google.rpc.RetryInfo";
    private static final String DEBUG_INFO_TYPE = "type.googleapis.com/google.rpc.DebugInfo";
    private static final String QUOTA_FAILURE_TYPE = "type.googleapis.com/google.rpc.QuotaFailure";
    private static final String PRECONDITION_FAILURE_TYPE = "type.googleapis.com/google.rpc.PreconditionFailure";
    private static final String BAD_REQUEST_TYPE = "type.googleapis.com/google.rpc.BadRequest";
    private static final String RESOURCE_INFO_TYPE = "type.googleapis.com/google.rpc.ResourceInfo";
    private static final String HELP_TYPE = "type.googleapis.com/google.rpc.Help";

    @Override
    public ErrorDetails deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(p);
        if (node.isArray()) {
            return this.deserializeFromArray((ArrayNode)node, mapper);
        }
        return this.deserializeFromObject((ObjectNode)node, mapper);
    }

    private ErrorDetails deserializeFromArray(ArrayNode arrayNode, ObjectMapper mapper) throws IOException {
        ErrorDetails.Builder builder = ErrorDetails.builder();
        ArrayList<JsonNode> unknownDetails = new ArrayList<JsonNode>();
        for (JsonNode detailNode : arrayNode) {
            if (detailNode.isObject()) {
                ObjectNode objectNode = (ObjectNode)detailNode;
                String type = objectNode.path("@type").asText();
                try {
                    switch (type) {
                        case "type.googleapis.com/google.rpc.ErrorInfo": {
                            ErrorInfo errorInfo = mapper.treeToValue((TreeNode)objectNode, ErrorInfo.class);
                            builder.setErrorInfo(errorInfo);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.RequestInfo": {
                            RequestInfo requestInfo = mapper.treeToValue((TreeNode)objectNode, RequestInfo.class);
                            builder.setRequestInfo(requestInfo);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.RetryInfo": {
                            RetryInfo retryInfo = mapper.treeToValue((TreeNode)objectNode, RetryInfo.class);
                            builder.setRetryInfo(retryInfo);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.DebugInfo": {
                            DebugInfo debugInfo = mapper.treeToValue((TreeNode)objectNode, DebugInfo.class);
                            builder.setDebugInfo(debugInfo);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.QuotaFailure": {
                            QuotaFailure quotaFailure = mapper.treeToValue((TreeNode)objectNode, QuotaFailure.class);
                            builder.setQuotaFailure(quotaFailure);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.PreconditionFailure": {
                            PreconditionFailure preconditionFailure = mapper.treeToValue((TreeNode)objectNode, PreconditionFailure.class);
                            builder.setPreconditionFailure(preconditionFailure);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.BadRequest": {
                            BadRequest badRequest = mapper.treeToValue((TreeNode)objectNode, BadRequest.class);
                            builder.setBadRequest(badRequest);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.ResourceInfo": {
                            ResourceInfo resourceInfo = mapper.treeToValue((TreeNode)objectNode, ResourceInfo.class);
                            builder.setResourceInfo(resourceInfo);
                            break;
                        }
                        case "type.googleapis.com/google.rpc.Help": {
                            Help help = mapper.treeToValue((TreeNode)objectNode, Help.class);
                            builder.setHelp(help);
                            break;
                        }
                        default: {
                            unknownDetails.add(detailNode);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    unknownDetails.add(detailNode);
                }
                continue;
            }
            unknownDetails.add(detailNode);
        }
        builder.setUnknownDetails(unknownDetails);
        return builder.build();
    }

    private ErrorDetails deserializeFromObject(ObjectNode objectNode, ObjectMapper mapper) throws IOException {
        String type = objectNode.path("@type").asText();
        try {
            switch (type) {
                case "type.googleapis.com/google.rpc.ErrorInfo": {
                    ErrorInfo errorInfo = mapper.treeToValue((TreeNode)objectNode, ErrorInfo.class);
                    return ErrorDetails.builder().setErrorInfo(errorInfo).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.RequestInfo": {
                    RequestInfo requestInfo = mapper.treeToValue((TreeNode)objectNode, RequestInfo.class);
                    return ErrorDetails.builder().setRequestInfo(requestInfo).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.RetryInfo": {
                    RetryInfo retryInfo = mapper.treeToValue((TreeNode)objectNode, RetryInfo.class);
                    return ErrorDetails.builder().setRetryInfo(retryInfo).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.DebugInfo": {
                    DebugInfo debugInfo = mapper.treeToValue((TreeNode)objectNode, DebugInfo.class);
                    return ErrorDetails.builder().setDebugInfo(debugInfo).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.QuotaFailure": {
                    QuotaFailure quotaFailure = mapper.treeToValue((TreeNode)objectNode, QuotaFailure.class);
                    return ErrorDetails.builder().setQuotaFailure(quotaFailure).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.PreconditionFailure": {
                    PreconditionFailure preconditionFailure = mapper.treeToValue((TreeNode)objectNode, PreconditionFailure.class);
                    return ErrorDetails.builder().setPreconditionFailure(preconditionFailure).build();
                }
                case "type.googleapis.com/google.rpc.BadRequest": {
                    BadRequest badRequest = mapper.treeToValue((TreeNode)objectNode, BadRequest.class);
                    return ErrorDetails.builder().setBadRequest(badRequest).build();
                }
                case "type.googleapis.com/google.rpc.ResourceInfo": {
                    ResourceInfo resourceInfo = mapper.treeToValue((TreeNode)objectNode, ResourceInfo.class);
                    return ErrorDetails.builder().setResourceInfo(resourceInfo).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
                case "type.googleapis.com/google.rpc.Help": {
                    Help help = mapper.treeToValue((TreeNode)objectNode, Help.class);
                    return ErrorDetails.builder().setHelp(help).setUnknownDetails(new ArrayList<JsonNode>()).build();
                }
            }
            ArrayList<JsonNode> unknownDetails = new ArrayList<JsonNode>();
            unknownDetails.add(objectNode);
            return ErrorDetails.builder().setUnknownDetails(unknownDetails).build();
        }
        catch (Exception e) {
            ArrayList<JsonNode> unknownDetails = new ArrayList<JsonNode>();
            unknownDetails.add(objectNode);
            return ErrorDetails.builder().setUnknownDetails(unknownDetails).build();
        }
    }
}

