/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.error.details;

import com.databricks.sdk.core.error.details.AutoValue_RetryInfo;
import java.io.IOException;
import java.time.Duration;
import org.talend.bigdata.google.auto.value.AutoValue;
import org.talend.bigdata.jackson.annotation.JsonIgnoreProperties;
import org.talend.bigdata.jackson.annotation.JsonProperty;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(builder=AutoValue_RetryInfo.Builder.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class RetryInfo {
    @JsonProperty(value="retry_delay")
    @JsonDeserialize(using=DurationDeserializer.class)
    public abstract Duration retryDelay();

    public static Builder builder() {
        return new AutoValue_RetryInfo.Builder();
    }

    static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        DurationDeserializer() {
        }

        @Override
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String fractionPart;
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            if (!node.isTextual()) {
                throw new IOException("Duration must be a string, got: " + (Object)((Object)node.getNodeType()));
            }
            String delayStr = node.asText();
            if (!delayStr.endsWith("s")) {
                throw new IOException("Duration must end with 's' suffix: " + delayStr);
            }
            String numeric = delayStr.substring(0, delayStr.length() - 1).trim();
            if (numeric.isEmpty()) {
                throw new IOException("Invalid duration format: " + delayStr);
            }
            if (numeric.startsWith("-")) {
                throw new IOException("Duration must be non-negative: " + delayStr);
            }
            int dotIdx = numeric.indexOf(46);
            String secondsPart = dotIdx >= 0 ? numeric.substring(0, dotIdx) : numeric;
            String string = fractionPart = dotIdx >= 0 ? numeric.substring(dotIdx + 1) : "";
            if (fractionPart.length() > 9) {
                throw new IOException("Fractional seconds precision exceeds nanoseconds: " + delayStr);
            }
            String fractionPadded = fractionPart.isEmpty() ? "" : (fractionPart + "000000000").substring(0, 9);
            try {
                long seconds = secondsPart.isEmpty() ? 0L : Long.parseLong(secondsPart);
                long nanos = fractionPadded.isEmpty() ? 0L : Long.parseLong(fractionPadded);
                return Duration.ofSeconds(seconds, nanos);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid duration format: " + delayStr, e);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="retry_delay")
        @JsonDeserialize(using=DurationDeserializer.class)
        public abstract Builder setRetryDelay(Duration var1);

        public abstract RetryInfo build();
    }
}

