/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.FormRequest;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenSource;
import java.io.IOException;
import java.time.Instant;
import org.talend.bigdata.google.common.base.Strings;
import org.talend.bigdata.google.common.collect.ImmutableMap;
import org.talend.bigdata.jackson.databind.ObjectMapper;

class OidcTokenSource
implements TokenSource {
    private final HttpClient httpClient;
    private final String tokenUrl;
    private final ImmutableMap<String, String> params;

    public OidcTokenSource(HttpClient httpClient, String tokenUrl, String clientId, String resource, String clientAssertion, String clientAssertionType) {
        this.httpClient = httpClient;
        this.tokenUrl = tokenUrl;
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        OidcTokenSource.putIfDefined(builder, "grant_type", "client_credentials");
        OidcTokenSource.putIfDefined(builder, "resource", resource);
        OidcTokenSource.putIfDefined(builder, "client_id", clientId);
        OidcTokenSource.putIfDefined(builder, "client_assertion_type", clientAssertionType);
        OidcTokenSource.putIfDefined(builder, "client_assertion", clientAssertion);
        this.params = builder.build();
    }

    private static void putIfDefined(ImmutableMap.Builder<String, String> builder, String key, String value) {
        if (!Strings.isNullOrEmpty(value)) {
            builder.put(key, value);
        }
    }

    @Override
    public Token getToken() {
        OAuthResponse resp;
        Response rawResp;
        try {
            rawResp = this.httpClient.execute(new FormRequest(this.tokenUrl, this.params));
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: " + e.getMessage(), e);
        }
        try {
            resp = new ObjectMapper().readValue(rawResp.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("Failed to request auth token: corrupted token: " + e.getMessage());
        }
        if (resp.getErrorCode() != null) {
            throw new IllegalArgumentException(resp.getErrorCode() + ": " + resp.getErrorSummary());
        }
        Instant expiry = Instant.now().plusSeconds(resp.getExpiresIn());
        return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
    }
}

