/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.FormRequest;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.OAuthResponse;
import com.databricks.sdk.core.oauth.Token;
import java.io.IOException;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.jackson.databind.ObjectMapper;

public final class TokenEndpointClient {
    private static final Logger LOG = LoggerFactory.getLogger(TokenEndpointClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TokenEndpointClient() {
    }

    public static OAuthResponse requestToken(HttpClient httpClient, String tokenEndpointUrl, Map<String, String> params) throws DatabricksException {
        OAuthResponse response;
        Response rawResponse;
        Objects.requireNonNull(httpClient, "HttpClient cannot be null");
        Objects.requireNonNull(params, "Request parameters map cannot be null");
        Objects.requireNonNull(tokenEndpointUrl, "Token endpoint URL cannot be null");
        if (tokenEndpointUrl.isEmpty()) {
            throw new IllegalArgumentException("Token endpoint URL cannot be empty");
        }
        try {
            LOG.debug("Requesting token from endpoint: {}", (Object)tokenEndpointUrl);
            rawResponse = httpClient.execute(new FormRequest(tokenEndpointUrl, params));
        }
        catch (IOException e) {
            LOG.error("Failed to request token from {}: {}", new Object[]{tokenEndpointUrl, e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to request token from %s: %s", tokenEndpointUrl, e.getMessage()), e);
        }
        try {
            response = OBJECT_MAPPER.readValue(rawResponse.getBody(), OAuthResponse.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse OAuth response from token endpoint {}: {}", new Object[]{tokenEndpointUrl, e.getMessage(), e});
            throw new DatabricksException(String.format("Failed to parse OAuth response from token endpoint %s: %s", tokenEndpointUrl, e.getMessage()), e);
        }
        if (response.getErrorCode() != null) {
            String errorSummary = response.getErrorSummary() != null ? response.getErrorSummary() : "No summary provided.";
            LOG.error("Token request to {} failed with error: {} - {}", new Object[]{tokenEndpointUrl, response.getErrorCode(), errorSummary});
            throw new DatabricksException(String.format("Token request failed with error: %s - %s", response.getErrorCode(), errorSummary));
        }
        LOG.debug("Successfully obtained token response from {}", (Object)tokenEndpointUrl);
        return response;
    }

    public static Token retrieveToken(HttpClient hc, String clientId, String clientSecret, String tokenUrl, Map<String, String> params, Map<String, String> headers, AuthParameterPosition position) {
        switch (position) {
            case BODY: {
                if (clientId != null) {
                    params.put("client_id", clientId);
                }
                if (clientSecret == null) break;
                params.put("client_secret", clientSecret);
                break;
            }
            case HEADER: {
                String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
                headers.put("Authorization", authHeaderValue);
            }
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Request req = new Request("POST", tokenUrl, FormRequest.wrapValuesInList(params));
        req.withHeaders(headers);
        try {
            ApiClient apiClient = new ApiClient.Builder().withHttpClient(hc).build();
            OAuthResponse resp = apiClient.execute(req, OAuthResponse.class);
            if (resp.getErrorCode() != null) {
                throw new IllegalArgumentException(resp.getErrorCode() + ": " + resp.getErrorSummary());
            }
            Instant expiry = Instant.now().plusSeconds(resp.getExpiresIn());
            return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
        }
        catch (Exception e) {
            throw new DatabricksException("Failed to refresh credentials: " + e.getMessage(), e);
        }
    }
}

