/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.utils;

import java.io.IOException;
import org.talend.bigdata.google.protobuf.Duration;
import org.talend.bigdata.google.protobuf.FieldMask;
import org.talend.bigdata.google.protobuf.Timestamp;
import org.talend.bigdata.google.protobuf.util.Durations;
import org.talend.bigdata.google.protobuf.util.Timestamps;
import org.talend.bigdata.jackson.core.JsonGenerator;
import org.talend.bigdata.jackson.core.JsonParser;
import org.talend.bigdata.jackson.databind.DeserializationContext;
import org.talend.bigdata.jackson.databind.JsonDeserializer;
import org.talend.bigdata.jackson.databind.JsonSerializer;
import org.talend.bigdata.jackson.databind.SerializerProvider;
import org.talend.bigdata.jackson.databind.module.SimpleModule;

public class ProtobufModule
extends SimpleModule {
    public ProtobufModule() {
        super("ProtobufModule");
        this.addSerializer(FieldMask.class, new FieldMaskSerializer());
        this.addDeserializer(FieldMask.class, new FieldMaskDeserializer());
        this.addSerializer(Duration.class, new DurationSerializer());
        this.addDeserializer(Duration.class, new DurationDeserializer());
        this.addSerializer(Timestamp.class, new TimestampSerializer());
        this.addDeserializer(Timestamp.class, new TimestampDeserializer());
    }

    public static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        @Override
        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String timestampString = p.getValueAsString();
            if (timestampString == null || timestampString.trim().isEmpty()) {
                return Timestamp.getDefaultInstance();
            }
            try {
                return Timestamps.parse(timestampString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid timestamp format: " + timestampString, e);
            }
        }
    }

    public static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        @Override
        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Timestamps.toString(timestamp));
        }
    }

    public static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        @Override
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String durationString = p.getValueAsString();
            if (durationString == null || durationString.trim().isEmpty()) {
                return Duration.getDefaultInstance();
            }
            try {
                return Durations.parse(durationString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid duration format: " + durationString, e);
            }
        }
    }

    public static class DurationSerializer
    extends JsonSerializer<Duration> {
        @Override
        public void serialize(Duration duration, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Durations.toString(duration));
        }
    }

    public static class FieldMaskDeserializer
    extends JsonDeserializer<FieldMask> {
        @Override
        public FieldMask deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] paths;
            String pathsString = p.getValueAsString();
            if (pathsString == null || pathsString.trim().isEmpty()) {
                return FieldMask.getDefaultInstance();
            }
            FieldMask.Builder builder = FieldMask.newBuilder();
            for (String path : paths = pathsString.split(",")) {
                String trimmedPath = path.trim();
                if (trimmedPath.isEmpty()) continue;
                builder.addPaths(trimmedPath);
            }
            return builder.build();
        }
    }

    public static class FieldMaskSerializer
    extends JsonSerializer<FieldMask> {
        @Override
        public void serialize(FieldMask fieldMask, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(String.join((CharSequence)",", fieldMask.getPathsList()));
        }
    }
}

