/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsImpl;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.sdk.service.catalog.AccountsCreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.AccountsCreateMetastoreAssignmentResponse;
import com.databricks.sdk.service.catalog.AccountsDeleteMetastoreAssignmentResponse;
import com.databricks.sdk.service.catalog.AccountsMetastoreAssignment;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastoreAssignment;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastoreAssignmentResponse;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreAssignmentRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreAssignmentRequest;
import com.databricks.sdk.service.catalog.ListAccountMetastoreAssignmentsRequest;
import com.databricks.sdk.service.catalog.ListAccountMetastoreAssignmentsResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountMetastoreAssignmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountMetastoreAssignmentsAPI.class);
    private final AccountMetastoreAssignmentsService impl;

    public AccountMetastoreAssignmentsAPI(ApiClient apiClient) {
        this.impl = new AccountMetastoreAssignmentsImpl(apiClient);
    }

    public AccountMetastoreAssignmentsAPI(AccountMetastoreAssignmentsService mock) {
        this.impl = mock;
    }

    public AccountsCreateMetastoreAssignmentResponse create(AccountsCreateMetastoreAssignment request) {
        return this.impl.create(request);
    }

    public AccountsDeleteMetastoreAssignmentResponse delete(long workspaceId, String metastoreId) {
        return this.delete(new DeleteAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public AccountsDeleteMetastoreAssignmentResponse delete(DeleteAccountMetastoreAssignmentRequest request) {
        return this.impl.delete(request);
    }

    public AccountsMetastoreAssignment get(long workspaceId) {
        return this.get(new GetAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public AccountsMetastoreAssignment get(GetAccountMetastoreAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Long> list(String metastoreId) {
        return this.list(new ListAccountMetastoreAssignmentsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<Long> list(ListAccountMetastoreAssignmentsRequest request) {
        return new Paginator(request, this.impl::list, ListAccountMetastoreAssignmentsResponse::getWorkspaceIds, response -> null);
    }

    public AccountsUpdateMetastoreAssignmentResponse update(AccountsUpdateMetastoreAssignment request) {
        return this.impl.update(request);
    }

    public AccountMetastoreAssignmentsService impl() {
        return this.impl;
    }
}

