/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dataquality;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.dataquality.CancelRefreshRequest;
import com.databricks.sdk.service.dataquality.CancelRefreshResponse;
import com.databricks.sdk.service.dataquality.CreateMonitorRequest;
import com.databricks.sdk.service.dataquality.CreateRefreshRequest;
import com.databricks.sdk.service.dataquality.DataQualityImpl;
import com.databricks.sdk.service.dataquality.DataQualityService;
import com.databricks.sdk.service.dataquality.DeleteMonitorRequest;
import com.databricks.sdk.service.dataquality.DeleteRefreshRequest;
import com.databricks.sdk.service.dataquality.GetMonitorRequest;
import com.databricks.sdk.service.dataquality.GetRefreshRequest;
import com.databricks.sdk.service.dataquality.ListMonitorRequest;
import com.databricks.sdk.service.dataquality.ListMonitorResponse;
import com.databricks.sdk.service.dataquality.ListRefreshRequest;
import com.databricks.sdk.service.dataquality.ListRefreshResponse;
import com.databricks.sdk.service.dataquality.Monitor;
import com.databricks.sdk.service.dataquality.Refresh;
import com.databricks.sdk.service.dataquality.UpdateMonitorRequest;
import com.databricks.sdk.service.dataquality.UpdateRefreshRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class DataQualityAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DataQualityAPI.class);
    private final DataQualityService impl;

    public DataQualityAPI(ApiClient apiClient) {
        this.impl = new DataQualityImpl(apiClient);
    }

    public DataQualityAPI(DataQualityService mock) {
        this.impl = mock;
    }

    public CancelRefreshResponse cancelRefresh(CancelRefreshRequest request) {
        return this.impl.cancelRefresh(request);
    }

    public Monitor createMonitor(CreateMonitorRequest request) {
        return this.impl.createMonitor(request);
    }

    public Refresh createRefresh(CreateRefreshRequest request) {
        return this.impl.createRefresh(request);
    }

    public void deleteMonitor(String objectType, String objectId) {
        this.deleteMonitor(new DeleteMonitorRequest().setObjectType(objectType).setObjectId(objectId));
    }

    public void deleteMonitor(DeleteMonitorRequest request) {
        this.impl.deleteMonitor(request);
    }

    public void deleteRefresh(String objectType, String objectId, long refreshId) {
        this.deleteRefresh(new DeleteRefreshRequest().setObjectType(objectType).setObjectId(objectId).setRefreshId(refreshId));
    }

    public void deleteRefresh(DeleteRefreshRequest request) {
        this.impl.deleteRefresh(request);
    }

    public Monitor getMonitor(String objectType, String objectId) {
        return this.getMonitor(new GetMonitorRequest().setObjectType(objectType).setObjectId(objectId));
    }

    public Monitor getMonitor(GetMonitorRequest request) {
        return this.impl.getMonitor(request);
    }

    public Refresh getRefresh(String objectType, String objectId, long refreshId) {
        return this.getRefresh(new GetRefreshRequest().setObjectType(objectType).setObjectId(objectId).setRefreshId(refreshId));
    }

    public Refresh getRefresh(GetRefreshRequest request) {
        return this.impl.getRefresh(request);
    }

    public Iterable<Monitor> listMonitor(ListMonitorRequest request) {
        return new Paginator(request, this.impl::listMonitor, ListMonitorResponse::getMonitors, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Refresh> listRefresh(String objectType, String objectId) {
        return this.listRefresh(new ListRefreshRequest().setObjectType(objectType).setObjectId(objectId));
    }

    public Iterable<Refresh> listRefresh(ListRefreshRequest request) {
        return new Paginator(request, this.impl::listRefresh, ListRefreshResponse::getRefreshes, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Monitor updateMonitor(UpdateMonitorRequest request) {
        return this.impl.updateMonitor(request);
    }

    public Refresh updateRefresh(UpdateRefreshRequest request) {
        return this.impl.updateRefresh(request);
    }

    public DataQualityService impl() {
        return this.impl;
    }
}

