/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.marketplace.CreateListingRequest;
import com.databricks.sdk.service.marketplace.CreateListingResponse;
import com.databricks.sdk.service.marketplace.DeleteListingRequest;
import com.databricks.sdk.service.marketplace.GetListingRequest;
import com.databricks.sdk.service.marketplace.GetListingResponse;
import com.databricks.sdk.service.marketplace.GetListingsRequest;
import com.databricks.sdk.service.marketplace.GetListingsResponse;
import com.databricks.sdk.service.marketplace.ProviderListingsService;
import com.databricks.sdk.service.marketplace.UpdateListingRequest;
import com.databricks.sdk.service.marketplace.UpdateListingResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProviderListingsImpl
implements ProviderListingsService {
    private final ApiClient apiClient;

    public ProviderListingsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateListingResponse create(CreateListingRequest request) {
        String path = "/api/2.0/marketplace-provider/listing";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateListingResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteListingRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/listings/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetListingResponse get(GetListingRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/listings/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetListingResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetListingsResponse list(GetListingsRequest request) {
        String path = "/api/2.0/marketplace-provider/listings";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetListingsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateListingResponse update(UpdateListingRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/listings/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateListingResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

