/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.marketplace.ListAllPersonalizationRequestsRequest;
import com.databricks.sdk.service.marketplace.ListAllPersonalizationRequestsResponse;
import com.databricks.sdk.service.marketplace.ProviderPersonalizationRequestsService;
import com.databricks.sdk.service.marketplace.UpdatePersonalizationRequestRequest;
import com.databricks.sdk.service.marketplace.UpdatePersonalizationRequestResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.UUID;

@Generated
class ProviderPersonalizationRequestsImpl
implements ProviderPersonalizationRequestsService {
    private final ApiClient apiClient;

    public ProviderPersonalizationRequestsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ListAllPersonalizationRequestsResponse list(ListAllPersonalizationRequestsRequest request) {
        String path = "/api/2.0/marketplace-provider/personalization-requests";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAllPersonalizationRequestsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdatePersonalizationRequestResponse update(UpdatePersonalizationRequestRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/listings/%s/personalization-requests/%s/request-status", request.getListingId(), request.getRequestId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            if (request.getRequestId() == null || request.getRequestId().isEmpty()) {
                request.setRequestId(UUID.randomUUID().toString());
            }
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdatePersonalizationRequestResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

