/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.google.auth.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.talend.bigdata.google.api.client.http.GenericUrl;
import org.talend.bigdata.google.api.client.http.HttpHeaders;
import org.talend.bigdata.google.api.client.http.HttpRequest;
import org.talend.bigdata.google.api.client.http.HttpResponse;
import org.talend.bigdata.google.api.client.http.HttpResponseException;
import org.talend.bigdata.google.api.client.http.UrlEncodedContent;
import org.talend.bigdata.google.api.client.json.GenericJson;
import org.talend.bigdata.google.api.client.json.JsonObjectParser;
import org.talend.bigdata.google.api.client.util.GenericData;
import org.talend.bigdata.google.api.client.util.Preconditions;
import org.talend.bigdata.google.auth.http.HttpTransportFactory;
import org.talend.bigdata.google.auth.oauth2.AccessToken;
import org.talend.bigdata.google.auth.oauth2.CredentialFormatException;
import org.talend.bigdata.google.auth.oauth2.GoogleCredentials;
import org.talend.bigdata.google.auth.oauth2.OAuth2Utils;
import org.talend.bigdata.google.auth.oauth2.OAuthException;
import org.talend.bigdata.google.common.base.MoreObjects;
import org.talend.bigdata.google.common.io.BaseEncoding;
import org.talend.bigdata.javax.annotation.Nullable;

public class ExternalAccountAuthorizedUserCredentials
extends GoogleCredentials {
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final long serialVersionUID = -2181779590486283287L;
    static final String EXTERNAL_ACCOUNT_AUTHORIZED_USER_FILE_TYPE = "external_account_authorized_user";
    private final String transportFactoryClassName;
    private final String audience;
    private final String tokenUrl;
    private final String tokenInfoUrl;
    private final String revokeUrl;
    private final String clientId;
    private final String clientSecret;
    private String refreshToken;
    private transient HttpTransportFactory transportFactory;

    private ExternalAccountAuthorizedUserCredentials(Builder builder) {
        super(builder);
        this.transportFactory = MoreObjects.firstNonNull(builder.transportFactory, ExternalAccountAuthorizedUserCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.audience = builder.audience;
        this.refreshToken = builder.refreshToken;
        this.tokenUrl = builder.tokenUrl;
        this.tokenInfoUrl = builder.tokenInfoUrl;
        this.revokeUrl = builder.revokeUrl;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        Preconditions.checkState(this.getAccessToken() != null || this.canRefresh(), "ExternalAccountAuthorizedUserCredentials must be initialized with an access token or fields to enable refresh: ('refresh_token', 'token_url', 'client_id', 'client_secret').");
    }

    public static ExternalAccountAuthorizedUserCredentials fromStream(InputStream credentialsStream) throws IOException {
        org.talend.bigdata.google.common.base.Preconditions.checkNotNull(credentialsStream);
        return ExternalAccountAuthorizedUserCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ExternalAccountAuthorizedUserCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        org.talend.bigdata.google.common.base.Preconditions.checkNotNull(credentialsStream);
        org.talend.bigdata.google.common.base.Preconditions.checkNotNull(transportFactory);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        try {
            return ExternalAccountAuthorizedUserCredentials.fromJson(fileContents, transportFactory);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new CredentialFormatException("Invalid input stream provided.", e);
        }
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        if (!this.canRefresh()) {
            throw new IllegalStateException("Unable to refresh ExternalAccountAuthorizedUserCredentials. All of 'refresh_token','token_url', 'client_id', 'client_secret' are required to refresh.");
        }
        try {
            HttpRequest httpRequest = this.buildRefreshRequest();
            response = httpRequest.execute();
        }
        catch (HttpResponseException e) {
            throw OAuthException.createFromHttpResponseException(e);
        }
        GenericData responseData = response.parseAs(GenericData.class);
        response.disconnect();
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        Date expiresAtMilliseconds = new Date(this.clock.currentTimeMillis() + (long)expiresInSeconds * 1000L);
        String refreshToken = OAuth2Utils.validateOptionalString(responseData, "refresh_token", PARSE_ERROR_PREFIX);
        if (refreshToken != null && refreshToken.trim().length() > 0) {
            this.refreshToken = refreshToken;
        }
        return AccessToken.newBuilder().setExpirationTime(expiresAtMilliseconds).setTokenValue(accessToken).build();
    }

    @Nullable
    public String getAudience() {
        return this.audience;
    }

    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Nullable
    public String getRevokeUrl() {
        return this.revokeUrl;
    }

    @Nullable
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Nullable
    public String getTokenInfoUrl() {
        return this.tokenInfoUrl;
    }

    @Nullable
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientId, this.clientSecret, this.refreshToken, this.tokenUrl, this.tokenInfoUrl, this.revokeUrl, this.audience, this.transportFactoryClassName, this.quotaProjectId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("requestMetadata", this.getRequestMetadataInternal()).add("temporaryAccess", this.getAccessToken()).add("clientId", this.clientId).add("clientSecret", this.clientSecret).add("refreshToken", this.refreshToken).add("tokenUrl", this.tokenUrl).add("tokenInfoUrl", this.tokenInfoUrl).add("revokeUrl", this.revokeUrl).add("audience", this.audience).add("transportFactoryClassName", this.transportFactoryClassName).add("quotaProjectId", this.quotaProjectId).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalAccountAuthorizedUserCredentials)) {
            return false;
        }
        ExternalAccountAuthorizedUserCredentials credentials = (ExternalAccountAuthorizedUserCredentials)obj;
        return super.equals(credentials) && Objects.equals(this.clientId, credentials.clientId) && Objects.equals(this.clientSecret, credentials.clientSecret) && Objects.equals(this.refreshToken, credentials.refreshToken) && Objects.equals(this.tokenUrl, credentials.tokenUrl) && Objects.equals(this.tokenInfoUrl, credentials.tokenInfoUrl) && Objects.equals(this.revokeUrl, credentials.revokeUrl) && Objects.equals(this.audience, credentials.audience) && Objects.equals(this.transportFactoryClassName, credentials.transportFactoryClassName) && Objects.equals(this.quotaProjectId, credentials.quotaProjectId);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    static ExternalAccountAuthorizedUserCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String audience = (String)json.get("audience");
        String refreshToken = (String)json.get("refresh_token");
        String tokenUrl = (String)json.get("token_url");
        String tokenInfoUrl = (String)json.get("token_info_url");
        String revokeUrl = (String)json.get("revoke_url");
        String clientId = (String)json.get("client_id");
        String clientSecret = (String)json.get("client_secret");
        String quotaProjectId = (String)json.get("quota_project_id");
        return ExternalAccountAuthorizedUserCredentials.newBuilder().setAudience(audience).setRefreshToken(refreshToken).setTokenUrl(tokenUrl).setTokenInfoUrl(tokenInfoUrl).setRevokeUrl(revokeUrl).setClientId(clientId).setClientSecret(clientSecret).setRefreshToken(refreshToken).setHttpTransportFactory(transportFactory).setQuotaProjectId(quotaProjectId).build();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ExternalAccountAuthorizedUserCredentials.newInstance(this.transportFactoryClassName);
    }

    private boolean canRefresh() {
        return this.refreshToken != null && this.refreshToken.trim().length() > 0 && this.tokenUrl != null && this.tokenUrl.trim().length() > 0 && this.clientId != null && this.clientId.trim().length() > 0 && this.clientSecret != null && this.clientSecret.trim().length() > 0;
    }

    private HttpRequest buildRefreshRequest() throws IOException {
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", "refresh_token");
        tokenRequest.set("refresh_token", this.refreshToken);
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildPostRequest(new GenericUrl(this.tokenUrl), new UrlEncodedContent(tokenRequest));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        HttpHeaders requestHeaders = request.getHeaders();
        requestHeaders.setAuthorization(String.format("Basic %s", BaseEncoding.base64().encode(String.format("%s:%s", this.clientId, this.clientSecret).getBytes(StandardCharsets.UTF_8))));
        return request;
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private HttpTransportFactory transportFactory;
        private String audience;
        private String refreshToken;
        private String tokenUrl;
        private String tokenInfoUrl;
        private String revokeUrl;
        private String clientId;
        private String clientSecret;

        protected Builder() {
        }

        protected Builder(ExternalAccountAuthorizedUserCredentials credentials) {
            super(credentials);
            this.transportFactory = credentials.transportFactory;
            this.audience = credentials.audience;
            this.refreshToken = credentials.refreshToken;
            this.tokenUrl = credentials.tokenUrl;
            this.tokenInfoUrl = credentials.tokenInfoUrl;
            this.revokeUrl = credentials.revokeUrl;
            this.clientId = credentials.clientId;
            this.clientSecret = credentials.clientSecret;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder setTokenInfoUrl(String tokenInfoUrl) {
            this.tokenInfoUrl = tokenInfoUrl;
            return this;
        }

        public Builder setRevokeUrl(String revokeUrl) {
            this.revokeUrl = revokeUrl;
            return this;
        }

        public Builder setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        public Builder setAccessToken(AccessToken accessToken) {
            super.setAccessToken(accessToken);
            return this;
        }

        @Override
        public ExternalAccountAuthorizedUserCredentials build() {
            return new ExternalAccountAuthorizedUserCredentials(this);
        }
    }
}

